/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.query;

import com.o19s.es.ltr.LtrQueryContext;
import com.o19s.es.ltr.feature.Feature;
import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.FeatureValidation;
import com.o19s.es.ltr.feature.store.CompiledLtrModel;
import com.o19s.es.ltr.feature.store.PrecompiledExpressionFeature;
import com.o19s.es.ltr.feature.store.StorableElement;
import com.o19s.es.ltr.feature.store.StoredFeature;
import com.o19s.es.ltr.feature.store.StoredFeatureSet;
import com.o19s.es.ltr.feature.store.StoredLtrModel;
import com.o19s.es.ltr.query.RankerQuery;
import com.o19s.es.ltr.ranker.linear.LinearRanker;
import com.o19s.es.ltr.ranker.parser.LtrRankerParserFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.ltr.stats.LTRStats;
import org.opensearch.ltr.stats.StatName;

public class ValidatingLtrQueryBuilder
extends AbstractQueryBuilder<ValidatingLtrQueryBuilder> {
    public static final Set<String> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("feature", "featureset", "model")));
    public static final String NAME = "validating_ltr_query";
    private static final ParseField VALIDATION = new ParseField("validation", new String[0]);
    private static final ObjectParser<ValidatingLtrQueryBuilder, Void> PARSER = new ObjectParser("validating_ltr_query");
    private final transient LtrRankerParserFactory factory;
    private StorableElement element;
    private FeatureValidation validation;
    private LTRStats ltrStats;

    private ValidatingLtrQueryBuilder(LtrRankerParserFactory factory) {
        this.factory = factory;
    }

    public ValidatingLtrQueryBuilder(StorableElement element, FeatureValidation validation, LtrRankerParserFactory factory, LTRStats ltrStats) {
        this(factory);
        this.element = Objects.requireNonNull(element);
        this.validation = Objects.requireNonNull(validation);
        this.ltrStats = ltrStats;
    }

    public ValidatingLtrQueryBuilder(StreamInput input, LtrRankerParserFactory factory, LTRStats ltrStats) throws IOException {
        super(input);
        String type;
        this.element = (StorableElement)(switch (type = input.readString()) {
            case "feature" -> StoredFeature::new;
            case "featureset" -> StoredFeatureSet::new;
            case "model" -> StoredLtrModel::new;
            default -> throw new IOException("Unsupported storable element [" + type + "]");
        }).read(input);
        this.validation = new FeatureValidation(input);
        this.factory = factory;
        this.ltrStats = ltrStats;
    }

    public static ValidatingLtrQueryBuilder fromXContent(XContentParser parser, LtrRankerParserFactory factory, LTRStats ltrStats) throws IOException {
        try {
            ValidatingLtrQueryBuilder builder = new ValidatingLtrQueryBuilder(factory);
            PARSER.parse(parser, (Object)builder, null);
            if (builder.element == null) {
                throw new ParsingException(parser.getTokenLocation(), "Element of type [" + SUPPORTED_TYPES.stream().collect(Collectors.joining(",")) + "] is mandatory.", new Object[0]);
            }
            if (builder.validation == null) {
                throw new ParsingException(parser.getTokenLocation(), "Expected field [" + VALIDATION.getPreferredName() + "]", new Object[0]);
            }
            builder.ltrStats(ltrStats);
            return builder;
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException(parser.getTokenLocation(), iae.getMessage(), (Throwable)iae, new Object[0]);
        }
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.element.getWriteableName());
        this.element.writeTo(out);
        this.validation.writeTo(out);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(this.element.type(), (ToXContent)this.element);
        builder.field(VALIDATION.getPreferredName(), (ToXContent)this.validation);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    protected Query doToQuery(QueryShardContext queryShardContext) throws IOException {
        this.ltrStats.getStat(StatName.LTR_REQUEST_TOTAL_COUNT.getName()).increment();
        try {
            return this.doToQueryInternal(queryShardContext);
        }
        catch (Exception e) {
            this.ltrStats.getStat(StatName.LTR_REQUEST_ERROR_COUNT.getName()).increment();
            throw e;
        }
    }

    private Query doToQueryInternal(QueryShardContext queryShardContext) throws IOException {
        LtrQueryContext context = new LtrQueryContext(queryShardContext);
        if ("feature".equals(this.element.type())) {
            Feature feature = ((StoredFeature)this.element).optimize();
            if (feature instanceof PrecompiledExpressionFeature) {
                return new MatchAllDocsQuery();
            }
            return feature.doToQuery(context, null, this.validation.getParams());
        }
        if ("featureset".equals(this.element.type())) {
            FeatureSet set = ((StoredFeatureSet)this.element).optimize();
            LinearRanker ranker = new LinearRanker(new float[set.size()]);
            CompiledLtrModel model = new CompiledLtrModel("validation", set, ranker);
            return RankerQuery.build(model, context, this.validation.getParams(), false, this.ltrStats);
        }
        if ("model".equals(this.element.type())) {
            CompiledLtrModel model = ((StoredLtrModel)this.element).compile(this.factory);
            return RankerQuery.build(model, context, this.validation.getParams(), false, this.ltrStats);
        }
        throw new QueryShardException(queryShardContext, "Unknown element type [" + this.element.type() + "]", new Object[0]);
    }

    protected boolean doEquals(ValidatingLtrQueryBuilder other) {
        return Objects.equals(this.element, other.element) && Objects.equals(this.validation, other.validation);
    }

    protected int doHashCode() {
        return Objects.hash(this.element, this.validation);
    }

    public String getWriteableName() {
        return NAME;
    }

    public StorableElement getElement() {
        return this.element;
    }

    public FeatureValidation getValidation() {
        return this.validation;
    }

    public ValidatingLtrQueryBuilder ltrStats(LTRStats ltrStats) {
        this.ltrStats = ltrStats;
        return this;
    }

    static {
        BiConsumer<ValidatingLtrQueryBuilder, StorableElement> setElem = (b, v) -> {
            if (b.element != null) {
                throw new IllegalArgumentException("[" + b.element.type() + "] already set, only one element can be set at a time (" + SUPPORTED_TYPES.stream().collect(Collectors.joining(",")) + ").");
            }
            b.element = v;
        };
        PARSER.declareObject(setElem, (parser, ctx) -> StoredFeature.parse(parser), new ParseField("feature", new String[0]));
        PARSER.declareObject(setElem, (parser, ctx) -> StoredFeatureSet.parse(parser), new ParseField("featureset", new String[0]));
        PARSER.declareObject(setElem, (parser, ctx) -> StoredLtrModel.parse(parser), new ParseField("model", new String[0]));
        PARSER.declareObject((b, v) -> {
            b.validation = v;
        }, (p, c) -> (FeatureValidation)FeatureValidation.PARSER.apply(p, null), new ParseField("validation", new String[0]));
        ValidatingLtrQueryBuilder.declareStandardFields(PARSER);
    }
}

