/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.ThreadPoolDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.admin.indices.resolve.ResolveIndexAction;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.alerting.action.GetRemoteIndexesRequest;
import org.opensearch.alerting.action.GetRemoteIndexesResponse;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transport.TransportGetRemoteIndexesActionKt;
import org.opensearch.alerting.util.CrossClusterMonitorUtils;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B9\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J&\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00022\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*H\u0014J\u001c\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0082@\u00a2\u0006\u0002\u00100J$\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\b2\f\u00104\u001a\b\u0012\u0004\u0012\u00020/0.H\u0082@\u00a2\u0006\u0002\u00105J$\u00106\u001a\u0002072\u0006\u00103\u001a\u00020\b2\f\u00108\u001a\b\u0012\u0004\u0012\u00020/0.H\u0082@\u00a2\u0006\u0002\u00105R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0018\u0010#\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"\u00a8\u00069"}, d2={"Lorg/opensearch/alerting/transport/TransportGetRemoteIndexesAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/GetRemoteIndexesRequest;", "Lorg/opensearch/alerting/action/GetRemoteIndexesResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;)V", "getTransportService", "()Lorg/opensearch/transport/TransportService;", "getClient", "()Lorg/opensearch/transport/client/Client;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "remoteMonitoringEnabled", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "getRemoteClusters", "Lorg/opensearch/action/admin/indices/resolve/ResolveIndexAction$Response;", "parsedIndexes", "", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getHealthStatuses", "Lorg/opensearch/action/admin/cluster/health/ClusterHealthResponse;", "targetClient", "parsedIndexesNames", "(Lorg/opensearch/transport/client/Client;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getIndexMappings", "Lorg/opensearch/action/admin/indices/mapping/get/GetMappingsResponse;", "parsedIndexNames", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nTransportGetRemoteIndexesAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportGetRemoteIndexesAction.kt\norg/opensearch/alerting/transport/TransportGetRemoteIndexesAction\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,202:1\n37#2:203\n36#2,3:204\n37#2:207\n36#2,3:208\n37#2:211\n36#2,3:212\n*S KotlinDebug\n*F\n+ 1 TransportGetRemoteIndexesAction.kt\norg/opensearch/alerting/transport/TransportGetRemoteIndexesAction\n*L\n177#1:203\n177#1:204,3\n187#1:207\n187#1:208,3\n196#1:211\n196#1:212,3\n*E\n"})
public final class TransportGetRemoteIndexesAction
extends HandledTransportAction<GetRemoteIndexesRequest, GetRemoteIndexesResponse>
implements SecureTransportAction {
    @NotNull
    private final TransportService transportService;
    @NotNull
    private final Client client;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final ClusterService clusterService;
    private volatile Boolean filterByEnabled;
    private volatile Boolean remoteMonitoringEnabled;

    @Inject
    public TransportGetRemoteIndexesAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry, @NotNull ClusterService clusterService, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super("cluster:admin/opensearch/alerting/remote/indexes/get", transportService, actionFilters, GetRemoteIndexesRequest::new);
        this.transportService = transportService;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(settings);
        this.remoteMonitoringEnabled = (Boolean)AlertingSettings.Companion.getCROSS_CLUSTER_MONITORING_ENABLED().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getCROSS_CLUSTER_MONITORING_ENABLED(), arg_0 -> TransportGetRemoteIndexesAction._init_$lambda$0(this, arg_0));
        this.listenFilterBySettingChange(this.clusterService);
    }

    @NotNull
    public final TransportService getTransportService() {
        return this.transportService;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull GetRemoteIndexesRequest request, @NotNull ActionListener<GetRemoteIndexesResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        TransportGetRemoteIndexesActionKt.access$getLog$p().debug("Remote monitoring enabled: {}", (Object)this.remoteMonitoringEnabled);
        if (!this.remoteMonitoringEnabled.booleanValue()) {
            actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Remote monitoring is not enabled.", RestStatus.FORBIDDEN, new Object[0])));
            return;
        }
        User user = this.readUserFromThreadContext(this.client);
        if (!this.validateUserBackendRoles(user, actionListener)) {
            return;
        }
        if (!request.isValid()) {
            actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Indexes includes an invalid pattern.", RestStatus.BAD_REQUEST, new Object[0])));
            return;
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            Job job = BuildersKt.launch$default((CoroutineScope)TransportGetRemoteIndexesActionKt.access$getScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, this, request, actionListener, null){
                Object L$0;
                int label;
                final /* synthetic */ ThreadContext.StoredContext $it;
                final /* synthetic */ TransportGetRemoteIndexesAction this$0;
                final /* synthetic */ GetRemoteIndexesRequest $request;
                final /* synthetic */ ActionListener<GetRemoteIndexesResponse> $actionListener;
                {
                    this.$it = $it;
                    this.this$0 = $receiver;
                    this.$request = $request;
                    this.$actionListener = $actionListener;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ExecutorCoroutineDispatcher singleThreadContext = ThreadPoolDispatcherKt.newSingleThreadContext((String)"GetRemoteIndexesActionThread");
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)singleThreadContext);
                            this.label = 1;
                            Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)singleThreadContext), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$it, this.this$0, this.$request, this.$actionListener, null){
                                Object L$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                Object L$4;
                                Object L$5;
                                Object L$6;
                                Object L$7;
                                Object L$8;
                                Object L$9;
                                Object L$10;
                                Object L$11;
                                Object L$12;
                                Object L$13;
                                Object L$14;
                                Object L$15;
                                Object L$16;
                                Object L$17;
                                int I$0;
                                int I$1;
                                long J$0;
                                int label;
                                final /* synthetic */ ThreadContext.StoredContext $it;
                                final /* synthetic */ TransportGetRemoteIndexesAction this$0;
                                final /* synthetic */ GetRemoteIndexesRequest $request;
                                final /* synthetic */ ActionListener<GetRemoteIndexesResponse> $actionListener;
                                {
                                    this.$it = $it;
                                    this.this$0 = $receiver;
                                    this.$request = $request;
                                    this.$actionListener = $actionListener;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var32_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.$it.restore();
                                            clusterIndexesList = new ArrayList<E>();
                                            resolveIndexResponse = null;
                                            this.L$0 = clusterIndexesList;
                                            this.label = 1;
                                            v0 = TransportGetRemoteIndexesAction.access$getRemoteClusters(this.this$0, this.$request.getIndexes(), (Continuation)this);
                                            ** if (v0 != var32_2) goto lbl15
lbl14:
                                            // 1 sources

                                            return var32_2;
lbl15:
                                            // 1 sources

                                            ** GOTO lbl23
                                        }
                                        case 1: {
                                            resolveIndexResponse = null;
                                            clusterIndexesList = (List)this.L$0;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl23:
                                                // 2 sources

                                                resolveIndexResponse = (ResolveIndexAction.Response)v0;
                                            }
                                            catch (Exception e) {
                                                TransportGetRemoteIndexesActionKt.access$getLog$p().error("Failed to retrieve indexes for request " + this.$request, (Throwable)e);
                                                this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(e));
                                            }
                                            resolvedIndexes = new ArrayList<E>();
                                            if (resolveIndexResponse != null) {
                                                v1 = resolveIndexResponse.getIndices();
                                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getIndices(...)");
                                                $this$forEach$iv = v1;
                                                $i$f$forEach = false;
                                                for (E element$iv : $this$forEach$iv) {
                                                    it = (ResolveIndexAction.ResolvedIndex)element$iv;
                                                    $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$1 = false;
                                                    v2 = it.getName();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getName(...)");
                                                    resolvedIndexes.add(v2);
                                                }
                                                v3 = resolveIndexResponse.getAliases();
                                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getAliases(...)");
                                                $this$forEach$iv = v3;
                                                $i$f$forEach = false;
                                                for (E element$iv : $this$forEach$iv) {
                                                    it = (ResolveIndexAction.ResolvedAlias)element$iv;
                                                    $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$2 = false;
                                                    v4 = it.getName();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getName(...)");
                                                    resolvedIndexes.add(v4);
                                                }
                                            }
                                            clusterIndexesMap = CrossClusterMonitorUtils.Companion.separateClusterIndexes((List<String>)resolvedIndexes, this.this$0.getClusterService());
                                            $i$f$forEach = clusterIndexesMap;
                                            var7_10 = this.this$0;
                                            var8_11 = this.$request;
                                            var9_12 = this.$actionListener;
                                            $i$f$forEach = 0;
                                            var11_14 = $this$forEach$iv.entrySet().iterator();
lbl61:
                                            // 2 sources

                                            while (var11_14.hasNext()) {
                                                var13_16 = element$iv = (Map.Entry)var11_14.next();
                                                $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$3 = 0;
                                                clusterName = (String)var13_16.getKey();
                                                indexes = (List)var13_16.getValue();
                                                targetClient = CrossClusterMonitorUtils.Companion.getClientForCluster(clusterName, var7_10.getClient(), var7_10.getClusterService());
                                                startTime = Instant.now();
                                                clusterHealthResponse = new Ref.ObjectRef();
                                                var20_23 = clusterHealthResponse;
                                                this.L$0 = clusterIndexesList;
                                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)resolveIndexResponse);
                                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)resolvedIndexes);
                                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)clusterIndexesMap);
                                                this.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                                                this.L$5 = var7_10;
                                                this.L$6 = var8_11;
                                                this.L$7 = var9_12;
                                                this.L$8 = var11_14;
                                                this.L$9 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                                                this.L$10 = clusterName;
                                                this.L$11 = indexes;
                                                this.L$12 = targetClient;
                                                this.L$13 = startTime;
                                                this.L$14 = clusterHealthResponse;
                                                this.L$15 = var20_23;
                                                this.L$16 = null;
                                                this.L$17 = null;
                                                this.I$0 = $i$f$forEach;
                                                this.I$1 = $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$3;
                                                this.label = 2;
                                                v5 = TransportGetRemoteIndexesAction.access$getHealthStatuses((TransportGetRemoteIndexesAction)var7_10, targetClient, indexes, (Continuation)this);
                                                ** if (v5 != var32_2) goto lbl96
lbl95:
                                                // 1 sources

                                                return var32_2;
lbl96:
                                                // 1 sources

                                                ** GOTO lbl121
                                            }
                                            break;
                                        }
                                        case 2: {
                                            $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$3 = this.I$1;
                                            $i$f$forEach = this.I$0;
                                            var20_23 = (Ref.ObjectRef)this.L$15;
                                            clusterHealthResponse = (Ref.ObjectRef)this.L$14;
                                            startTime = (Instant)this.L$13;
                                            targetClient = (Client)this.L$12;
                                            indexes = (List)this.L$11;
                                            clusterName = (String)this.L$10;
                                            element$iv = (Map.Entry)this.L$9;
                                            var11_14 = (Iterator)this.L$8;
                                            var9_12 = (ActionListener)this.L$7;
                                            var8_11 = (GetRemoteIndexesRequest)this.L$6;
                                            var7_10 = (TransportGetRemoteIndexesAction)this.L$5;
                                            $this$forEach$iv = (Map)this.L$4;
                                            clusterIndexesMap = (HashMap)this.L$3;
                                            resolvedIndexes = (List)this.L$2;
                                            resolveIndexResponse = (ResolveIndexAction.Response)this.L$1;
                                            clusterIndexesList = (List)this.L$0;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v5 = $result;
lbl121:
                                                // 2 sources

                                                var20_23.element = v5;
                                            }
                                            catch (Exception e) {
                                                TransportGetRemoteIndexesActionKt.access$getLog$p().error("Failed to retrieve health statuses for request " + var8_11, (Throwable)e);
                                                var9_12.onFailure((Exception)AlertingException.Companion.wrap(e));
                                            }
                                            endTime = Instant.now();
                                            latency = Duration.between(startTime, endTime).toMillis();
                                            mappingsResponse = new Ref.ObjectRef();
                                            if (!var8_11.getIncludeMappings()) ** GOTO lbl190
                                            var20_23 = mappingsResponse;
                                            this.L$0 = clusterIndexesList;
                                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)resolveIndexResponse);
                                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)resolvedIndexes);
                                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)clusterIndexesMap);
                                            this.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                                            this.L$5 = var7_10;
                                            this.L$6 = var8_11;
                                            this.L$7 = var9_12;
                                            this.L$8 = var11_14;
                                            this.L$9 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                                            this.L$10 = clusterName;
                                            this.L$11 = indexes;
                                            this.L$12 = SpillingKt.nullOutSpilledVariable((Object)targetClient);
                                            this.L$13 = SpillingKt.nullOutSpilledVariable((Object)startTime);
                                            this.L$14 = clusterHealthResponse;
                                            this.L$15 = var20_23;
                                            this.L$16 = SpillingKt.nullOutSpilledVariable((Object)endTime);
                                            this.L$17 = mappingsResponse;
                                            this.I$0 = $i$f$forEach;
                                            this.I$1 = $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$3;
                                            this.J$0 = latency;
                                            this.label = 3;
                                            v6 = TransportGetRemoteIndexesAction.access$getIndexMappings((TransportGetRemoteIndexesAction)var7_10, targetClient, indexes, (Continuation)this);
                                            ** if (v6 != var32_2) goto lbl158
lbl157:
                                            // 1 sources

                                            return var32_2;
lbl158:
                                            // 1 sources

                                            ** GOTO lbl185
                                        }
                                        case 3: {
                                            latency = this.J$0;
                                            $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$3 = this.I$1;
                                            $i$f$forEach = this.I$0;
                                            mappingsResponse = (Ref.ObjectRef)this.L$17;
                                            endTime = (Instant)this.L$16;
                                            var20_23 = (Ref.ObjectRef)this.L$15;
                                            clusterHealthResponse = (Ref.ObjectRef)this.L$14;
                                            startTime = (Instant)this.L$13;
                                            targetClient = (Client)this.L$12;
                                            indexes = (List)this.L$11;
                                            clusterName = (String)this.L$10;
                                            element$iv = (Map.Entry)this.L$9;
                                            var11_14 = (Iterator)this.L$8;
                                            var9_12 = (ActionListener)this.L$7;
                                            var8_11 = (GetRemoteIndexesRequest)this.L$6;
                                            var7_10 = (TransportGetRemoteIndexesAction)this.L$5;
                                            $this$forEach$iv = (Map)this.L$4;
                                            clusterIndexesMap = (HashMap)this.L$3;
                                            resolvedIndexes = (List)this.L$2;
                                            resolveIndexResponse = (ResolveIndexAction.Response)this.L$1;
                                            clusterIndexesList = (List)this.L$0;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v6 = $result;
lbl185:
                                                // 2 sources

                                                var20_23.element = v6;
                                            }
                                            catch (Exception e) {
                                                TransportGetRemoteIndexesActionKt.access$getLog$p().error("Failed to retrieve mappings for request " + var8_11, (Throwable)e);
                                                var9_12.onFailure((Exception)AlertingException.Companion.wrap(e));
                                            }
lbl190:
                                            // 3 sources

                                            clusterIndexList = new ArrayList<E>();
                                            if (clusterHealthResponse.element != null) {
                                                $this$forEach$iv = indexes;
                                                $i$f$forEach = false;
                                                for (T element$iv : $this$forEach$iv) {
                                                    it = (String)element$iv;
                                                    $i$a$-forEach-TransportGetRemoteIndexesAction$doExecute$1$1$1$3$1 = false;
                                                    v7 = (ClusterIndexHealth)((ClusterHealthResponse)clusterHealthResponse.element).getIndices().get(it);
                                                    clusterIndexList.add(new GetRemoteIndexesResponse.ClusterIndexes.ClusterIndex(it, (ClusterHealthStatus)(v7 != null ? v7.getStatus() : null), (v8 = (GetMappingsResponse)mappingsResponse.element) != null && (v8 = v8.getMappings()) != null ? (MappingMetadata)v8.get(it) : null));
                                                }
                                            }
                                            v9 = (ClusterHealthResponse)clusterHealthResponse.element;
                                            clusterIndexesList.add(new GetRemoteIndexesResponse.ClusterIndexes(clusterName, (ClusterHealthStatus)(v9 != null ? v9.getStatus() : null), Intrinsics.areEqual((Object)clusterName, (Object)var7_10.getClusterService().getClusterName().value()), clusterIndexList, latency));
                                            ** GOTO lbl61
                                        }
                                    }
                                    this.$actionListener.onResponse((Object)new GetRemoteIndexesResponse(clusterIndexesList));
                                    return Unit.INSTANCE;
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ExecutorCoroutineDispatcher singleThreadContext = (ExecutorCoroutineDispatcher)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final Object getRemoteClusters(List<String> parsedIndexes, Continuation<? super ResolveIndexAction.Response> $completion) {
        Collection $this$toTypedArray$iv = parsedIndexes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ResolveIndexAction.Request resolveRequest = new ResolveIndexAction.Request(thisCollection$iv.toArray(new String[0]), ResolveIndexAction.Request.DEFAULT_INDICES_OPTIONS);
        return OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (arg_0, arg_1) -> TransportGetRemoteIndexesAction.getRemoteClusters$lambda$2(resolveRequest, arg_0, arg_1), $completion);
    }

    private final Object getHealthStatuses(Client targetClient, List<String> parsedIndexesNames, Continuation<? super ClusterHealthResponse> $completion) {
        Collection $this$toTypedArray$iv = parsedIndexesNames;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        ClusterHealthRequest clusterHealthRequest = new ClusterHealthRequest().indices(Arrays.copyOf(stringArray, stringArray.length)).indicesOptions(IndicesOptions.lenientExpandHidden());
        return OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)targetClient), (arg_0, arg_1) -> TransportGetRemoteIndexesAction.getHealthStatuses$lambda$3(clusterHealthRequest, arg_0, arg_1), $completion);
    }

    private final Object getIndexMappings(Client targetClient, List<String> parsedIndexNames, Continuation<? super GetMappingsResponse> $completion) {
        Collection $this$toTypedArray$iv = parsedIndexNames;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        GetMappingsRequest getMappingsRequest = (GetMappingsRequest)new GetMappingsRequest().indices(Arrays.copyOf(stringArray, stringArray.length));
        return OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)targetClient), (arg_0, arg_1) -> TransportGetRemoteIndexesAction.getIndexMappings$lambda$4(getMappingsRequest, arg_0, arg_1), $completion);
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.super.listenFilterBySettingChange(clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.super.readUserFromThreadContext(client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.super.doFilterForUser(user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.super.isAdmin(user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.super.validateUserBackendRoles(user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.super.checkUserPermissionsWithResource(requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    private static final void _init_$lambda$0(TransportGetRemoteIndexesAction this$0, Boolean it) {
        this$0.remoteMonitoringEnabled = it;
    }

    private static final Unit getRemoteClusters$lambda$2(ResolveIndexAction.Request $resolveRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.admin().indices().resolveIndex($resolveRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit getHealthStatuses$lambda$3(ClusterHealthRequest $clusterHealthRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.admin().cluster().health($clusterHealthRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit getIndexMappings$lambda$4(GetMappingsRequest $getMappingsRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.admin().indices().getMappings($getMappingsRequest, it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$getRemoteClusters(TransportGetRemoteIndexesAction $this, List parsedIndexes, Continuation $completion) {
        return $this.getRemoteClusters(parsedIndexes, (Continuation<? super ResolveIndexAction.Response>)$completion);
    }

    public static final /* synthetic */ Object access$getHealthStatuses(TransportGetRemoteIndexesAction $this, Client targetClient, List parsedIndexesNames, Continuation $completion) {
        return $this.getHealthStatuses(targetClient, parsedIndexesNames, (Continuation<? super ClusterHealthResponse>)$completion);
    }

    public static final /* synthetic */ Object access$getIndexMappings(TransportGetRemoteIndexesAction $this, Client targetClient, List parsedIndexNames, Continuation $completion) {
        return $this.getIndexMappings(targetClient, parsedIndexNames, (Continuation<? super GetMappingsResponse>)$completion);
    }
}

