/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.metric;

import ai.djl.metric.Dimension;
import ai.djl.metric.MetricType;
import ai.djl.metric.Unit;
import com.google.gson.annotations.SerializedName;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Metric {
    private static final Pattern PATTERN = Pattern.compile("\\s*([\\w\\s]+)\\.([\\w\\s]+):([0-9\\-,.e]+)(?>\\|#([^|]*))?(?>\\|(\\d+))?(?>\\|([cgh]))?");
    private static final Dimension[] HOST = new Dimension[]{new Dimension("Host", Metric.getLocalHostName())};
    @SerializedName(value="MetricName")
    private String metricName;
    private transient MetricType metricType;
    @SerializedName(value="Value")
    private String value;
    @SerializedName(value="Unit")
    private String unit;
    @SerializedName(value="Dimensions")
    private Dimension[] dimensions;
    @SerializedName(value="Timestamp")
    private String timestamp;

    public Metric(String metricName, Number value) {
        this(metricName, value, Unit.COUNT, new Dimension[0]);
    }

    public Metric(String metricName, Number value, Unit unit, Dimension ... dimensions) {
        this(metricName, null, value, unit, dimensions);
    }

    public Metric(String metricName, MetricType metricType, Number value, Unit unit, Dimension ... dimensions) {
        this(metricName, metricType, value.toString(), unit.getValue(), null, dimensions);
    }

    private Metric(String metricName, MetricType metricType, String value, String unit, String timestamp, Dimension ... dimensions) {
        this.metricName = metricName;
        this.metricType = metricType;
        this.unit = unit;
        this.value = value;
        this.timestamp = timestamp;
        this.dimensions = dimensions.length == 0 ? HOST : dimensions;
    }

    public Metric copyOf(String name) {
        return new Metric(name, this.metricType, this.value, this.unit, this.timestamp, this.dimensions);
    }

    public String getMetricName() {
        return this.metricName;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public Double getValue() {
        return Double.valueOf(this.value);
    }

    public Unit getUnit() {
        return Unit.fromValue(this.unit);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Dimension[] getDimensions() {
        return this.dimensions;
    }

    public static Metric parse(String line) {
        Dimension[] dimensions;
        MetricType metricType;
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        String metricName = matcher.group(1);
        String unit = matcher.group(2);
        String value = matcher.group(3);
        String dimension = matcher.group(4);
        String timestamp = matcher.group(5);
        String type = matcher.group(6);
        MetricType metricType2 = metricType = type == null ? null : MetricType.of(type);
        if (dimension != null) {
            String[] dims = dimension.split(",");
            dimensions = new Dimension[dims.length];
            int index = 0;
            for (String dim : dims) {
                String[] pair = dim.split(":");
                if (pair.length != 2) continue;
                dimensions[index++] = new Dimension(pair[0], pair[1]);
            }
        } else {
            dimensions = HOST;
        }
        return new Metric(metricName, metricType, value, unit, timestamp, dimensions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.metricName).append('.').append(this.unit).append(':').append(this.value);
        if (this.dimensions != null) {
            boolean first = true;
            for (Dimension dimension : this.dimensions) {
                if (dimension == null) continue;
                if (first) {
                    sb.append("|#");
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(dimension.getName()).append(':').append(dimension.getValue());
            }
        }
        if (this.timestamp != null) {
            sb.append('|').append(this.timestamp);
        }
        if (this.metricType != null) {
            sb.append('|').append(this.metricType.getValue());
        }
        return sb.toString();
    }

    private static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "Unknown";
        }
    }
}

