/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.compiler;

import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.io.Serializable;

public final class JBBPNamedFieldInfo
implements Serializable {
    private static final long serialVersionUID = -3830704680293509892L;
    private final String fieldPath;
    private final String fieldName;
    private final int offsetInCompiledBlock;

    public JBBPNamedFieldInfo(String fieldPath, String fieldName, int offsetInCompiledBlock) {
        this.fieldPath = JBBPUtils.normalizeFieldNameOrPath(fieldPath);
        this.fieldName = JBBPUtils.normalizeFieldNameOrPath(fieldName);
        this.offsetInCompiledBlock = offsetInCompiledBlock;
    }

    public String getFieldPath() {
        return this.fieldPath;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getFieldOffsetInCompiledBlock() {
        return this.offsetInCompiledBlock;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        boolean result = false;
        if (obj instanceof JBBPNamedFieldInfo) {
            JBBPNamedFieldInfo that = (JBBPNamedFieldInfo)obj;
            result = this.fieldPath.equals(that.fieldPath) && this.offsetInCompiledBlock == that.offsetInCompiledBlock;
        }
        return result;
    }

    public int hashCode() {
        return this.offsetInCompiledBlock;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[fieldPath=" + this.fieldPath + ", fieldName=" + this.fieldName + ", offsetInCompiledBlock=" + this.offsetInCompiledBlock + ']';
    }
}

