/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.types.Command;
import org.openhab.core.types.ComplexType;
import org.openhab.core.types.PrimitiveType;
import org.openhab.core.types.State;
import org.openhab.core.util.ColorUtil;

@NonNullByDefault
public class HSBType
extends PercentType
implements ComplexType,
State,
Command {
    private static final long serialVersionUID = 322902950356613226L;
    public static final String KEY_HUE = "h";
    public static final String KEY_SATURATION = "s";
    public static final String KEY_BRIGHTNESS = "b";
    public static final HSBType BLACK = new HSBType("0,0,0");
    public static final HSBType WHITE = new HSBType("0,0,100");
    public static final HSBType RED = new HSBType("0,100,100");
    public static final HSBType GREEN = new HSBType("120,100,100");
    public static final HSBType BLUE = new HSBType("240,100,100");
    private static final String UNIT_HSB = "%hsb%";
    private static final String UNIT_RGB = "%rgb%";
    protected BigDecimal hue;
    protected BigDecimal saturation;

    public HSBType() {
        this("0,0,0");
    }

    public HSBType(DecimalType h, PercentType s, PercentType b) {
        this.hue = h.toBigDecimal();
        this.saturation = s.toBigDecimal();
        this.value = b.toBigDecimal();
        this.validateValue(this.hue, this.saturation, this.value);
    }

    public HSBType(String value) {
        List<String> constituents = Arrays.stream(value.split(",")).map(String::trim).toList();
        if (constituents.size() != 3) {
            throw new IllegalArgumentException(value + " is not a valid HSBType syntax");
        }
        this.hue = new BigDecimal(constituents.get(0));
        this.saturation = new BigDecimal(constituents.get(1));
        this.value = new BigDecimal(constituents.get(2));
        this.validateValue(this.hue, this.saturation, this.value);
    }

    private void validateValue(BigDecimal hue, BigDecimal saturation, BigDecimal value) {
        if (BigDecimal.ZERO.compareTo(hue) > 0 || BigDecimal.valueOf(360L).compareTo(hue) <= 0) {
            throw new IllegalArgumentException("Hue must be between 0 and 360");
        }
        if (BigDecimal.ZERO.compareTo(saturation) > 0 || BIG_DECIMAL_HUNDRED.compareTo(saturation) < 0) {
            throw new IllegalArgumentException("Saturation must be between 0 and 100");
        }
        if (BigDecimal.ZERO.compareTo(value) > 0 || BIG_DECIMAL_HUNDRED.compareTo(value) < 0) {
            throw new IllegalArgumentException("Brightness must be between 0 and 100");
        }
    }

    public static HSBType valueOf(String value) {
        return new HSBType(value);
    }

    public static HSBType fromRGB(int r, int g, int b) throws IllegalArgumentException {
        return ColorUtil.rgbToHsb(new int[]{r, g, b});
    }

    @Deprecated
    public static HSBType fromXY(float x, float y) throws IllegalArgumentException {
        return ColorUtil.xyToHsb(new double[]{x, y});
    }

    @Override
    public SortedMap<String, PrimitiveType> getConstituents() {
        TreeMap<String, PrimitiveType> map = new TreeMap<String, PrimitiveType>();
        map.put(KEY_HUE, this.getHue());
        map.put(KEY_SATURATION, this.getSaturation());
        map.put(KEY_BRIGHTNESS, this.getBrightness());
        return map;
    }

    public DecimalType getHue() {
        return new DecimalType(this.hue);
    }

    public PercentType getSaturation() {
        return new PercentType(this.saturation);
    }

    public PercentType getBrightness() {
        return new PercentType(this.value);
    }

    @Deprecated
    public PercentType getRed() {
        return this.toRGB()[0];
    }

    @Deprecated
    public PercentType getGreen() {
        return this.toRGB()[1];
    }

    @Deprecated
    public PercentType getBlue() {
        return this.toRGB()[2];
    }

    @Deprecated
    public int getRGB() {
        return ColorUtil.hsbTosRgb(this);
    }

    @Override
    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        return String.valueOf(this.getHue()) + "," + String.valueOf(this.getSaturation()) + "," + String.valueOf(this.getBrightness());
    }

    @Override
    public String format(String pattern) {
        String formatPattern = pattern;
        String val = String.valueOf(this.getHue()) + "," + String.valueOf(this.getSaturation()) + "," + String.valueOf(this.getBrightness());
        if (pattern.contains(UNIT_HSB)) {
            formatPattern = pattern.replace(UNIT_HSB, "%s");
        } else if (pattern.contains(UNIT_RGB)) {
            formatPattern = pattern.replace(UNIT_RGB, "%s");
            PercentType[] rgb = this.toRGB();
            val = this.convertPercentToByte(rgb[0]) + "," + this.convertPercentToByte(rgb[1]) + "," + this.convertPercentToByte(rgb[2]);
        }
        return String.format(formatPattern, val);
    }

    @Override
    public int hashCode() {
        int tmp = 10000 * this.getHue().hashCode();
        tmp += 100 * this.getSaturation().hashCode();
        return tmp += this.getBrightness().hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HSBType)) {
            return false;
        }
        HSBType other = (HSBType)obj;
        return this.getHue().equals(other.getHue()) && this.getSaturation().equals(other.getSaturation()) && this.getBrightness().equals(other.getBrightness());
    }

    @Deprecated
    public PercentType[] toRGB() {
        return ColorUtil.hsbToRgbPercent(this);
    }

    public PercentType[] toXY() {
        return (PercentType[])Arrays.stream(ColorUtil.hsbToXY(this)).mapToObj(d -> new PercentType(new BigDecimal(d * 100.0))).toArray(PercentType[]::new);
    }

    private int convertPercentToByte(PercentType percent) {
        return percent.value.multiply(BigDecimal.valueOf(255L)).divide(BIG_DECIMAL_HUNDRED, 0, RoundingMode.HALF_UP).intValue();
    }

    @Override
    public <T extends State> @Nullable T as(@Nullable Class<T> target) {
        if (target == OnOffType.class) {
            return (T)((State)target.cast(OnOffType.from(!PercentType.ZERO.equals(this.getBrightness()))));
        }
        if (target == DecimalType.class) {
            return (T)((State)target.cast(new DecimalType(this.getBrightness().toBigDecimal().divide(BIG_DECIMAL_HUNDRED, 8, RoundingMode.UP))));
        }
        if (target == PercentType.class) {
            return (T)((State)target.cast(new PercentType(this.getBrightness().toBigDecimal())));
        }
        return this.defaultConversion(target);
    }

    public boolean closeTo(HSBType other, double maxPercentage) throws IllegalArgumentException {
        double[] act;
        if (maxPercentage <= 0.0 || maxPercentage > 1.0) {
            throw new IllegalArgumentException("'maxPercentage' out of bounds, allowed range 0..1");
        }
        double[] exp = ColorUtil.hsbToXY(this);
        return Math.abs(exp[0] - (act = ColorUtil.hsbToXY(other))[0]) < maxPercentage && Math.abs(exp[1] - act[1]) < maxPercentage;
    }
}

