/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.rest.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.dto.RuleTemplateDTO;
import org.openhab.core.automation.dto.RuleTemplateDTOMapper;
import org.openhab.core.automation.template.RuleTemplate;
import org.openhab.core.automation.template.Template;
import org.openhab.core.automation.template.TemplateRegistry;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="templates")
@Tag(name="templates")
@Component
@JaxrsResource
@JaxrsName(value="templates")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class TemplateResource
implements RESTResource {
    public static final String PATH_TEMPLATES = "templates";
    private final LocaleService localeService;
    private final TemplateRegistry<@NonNull RuleTemplate> templateRegistry;

    @Activate
    public TemplateResource(@Reference LocaleService localeService, @Reference TemplateRegistry<@NonNull RuleTemplate> templateRegistry) {
        this.localeService = localeService;
        this.templateRegistry = templateRegistry;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getTemplates", summary="Get all available templates.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Template.class)))})})
    public Response getAll(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Locale locale = this.localeService.getLocale(language);
        List<RuleTemplateDTO> result = this.templateRegistry.getAll(locale).stream().map(template -> RuleTemplateDTOMapper.map((RuleTemplate)template)).toList();
        return Response.ok(result).build();
    }

    @GET
    @Path(value="/{templateUID}")
    @Produces(value={"application/json"})
    @Operation(operationId="getTemplateById", summary="Gets a template corresponding to the given UID.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=Template.class))}), @ApiResponse(responseCode="404", description="Template corresponding to the given UID does not found.")})
    public Response getByUID(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="templateUID") @Parameter(description="templateUID") String templateUID) {
        Locale locale = this.localeService.getLocale(language);
        RuleTemplate template = (RuleTemplate)this.templateRegistry.get(templateUID, locale);
        if (template != null) {
            return Response.ok((Object)RuleTemplateDTOMapper.map((RuleTemplate)template)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

