/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.discovery;

import org.jupnp.model.Location;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.OutgoingDatagramMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.header.EXTHeader;
import org.jupnp.model.message.header.InterfaceMacHeader;
import org.jupnp.model.message.header.LocationHeader;
import org.jupnp.model.message.header.MaxAgeHeader;
import org.jupnp.model.message.header.ServerHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.LocalDevice;

public class OutgoingSearchResponse
extends OutgoingDatagramMessage<UpnpResponse> {
    public OutgoingSearchResponse(IncomingDatagramMessage request, Location location, LocalDevice device) {
        super(new UpnpResponse(UpnpResponse.Status.OK), request.getSourceAddress(), request.getSourcePort());
        this.getHeaders().add(UpnpHeader.Type.MAX_AGE, new MaxAgeHeader(((DeviceIdentity)device.getIdentity()).getMaxAgeSeconds()));
        this.getHeaders().add(UpnpHeader.Type.LOCATION, new LocationHeader(location.getURL()));
        this.getHeaders().add(UpnpHeader.Type.SERVER, new ServerHeader());
        this.getHeaders().add(UpnpHeader.Type.EXT, new EXTHeader());
        if ("true".equals(System.getProperty("org.jupnp.network.announceMACAddress")) && location.getNetworkAddress().getHardwareAddress() != null) {
            this.getHeaders().add(UpnpHeader.Type.EXT_IFACE_MAC, new InterfaceMacHeader(location.getNetworkAddress().getHardwareAddress()));
        }
    }
}

