/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.mqtt.internal.client;

import com.hivemq.client.mqtt.MqttClientSslConfigBuilder;
import com.hivemq.client.mqtt.MqttClientState;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedListener;
import com.hivemq.client.mqtt.mqtt5.Mqtt5AsyncClient;
import com.hivemq.client.mqtt.mqtt5.Mqtt5Client;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientBuilder;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5ConnectBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscribe;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5SubscribeBuilder;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.Mqtt5Unsubscribe;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.Mqtt5UnsubscribeBuilder;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.mqtt.MqttBrokerConnection;
import org.openhab.core.io.transport.mqtt.MqttWillAndTestament;
import org.openhab.core.io.transport.mqtt.internal.Subscription;
import org.openhab.core.io.transport.mqtt.internal.client.MqttAsyncClientWrapper;

@NonNullByDefault
public class Mqtt5AsyncClientWrapper
extends MqttAsyncClientWrapper {
    private final Mqtt5AsyncClient client;

    public Mqtt5AsyncClientWrapper(String host, int port, String clientId, MqttBrokerConnection.Protocol protocol, boolean secure, boolean hostnameValidated, MqttBrokerConnection.ConnectionCallback connectionCallback, @Nullable TrustManagerFactory trustManagerFactory) {
        Mqtt5ClientBuilder clientBuilder = (Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)Mqtt5Client.builder().serverHost(host)).serverPort(port)).identifier(clientId)).addConnectedListener((MqttClientConnectedListener)connectionCallback)).addDisconnectedListener((MqttClientDisconnectedListener)connectionCallback);
        if (protocol == MqttBrokerConnection.Protocol.WEBSOCKETS) {
            clientBuilder.webSocketWithDefaultConfig();
        }
        if (secure) {
            if (hostnameValidated) {
                ((MqttClientSslConfigBuilder.Nested)((Mqtt5ClientBuilder)clientBuilder.sslWithDefaultConfig()).sslConfig().trustManagerFactory(trustManagerFactory)).applySslConfig();
            } else {
                ((MqttClientSslConfigBuilder.Nested)((MqttClientSslConfigBuilder.Nested)((Mqtt5ClientBuilder)clientBuilder.sslWithDefaultConfig()).sslConfig().trustManagerFactory(trustManagerFactory)).hostnameVerifier((HostnameVerifier)this)).applySslConfig();
            }
        }
        this.client = clientBuilder.buildAsync();
    }

    @Override
    public MqttClientState getState() {
        return this.client.getState();
    }

    @Override
    public CompletableFuture<?> subscribe(String topic, int qos, Subscription subscription) {
        Mqtt5Subscribe subscribeMessage = ((Mqtt5SubscribeBuilder.Start.Complete)((Mqtt5SubscribeBuilder.Start.Complete)Mqtt5Subscribe.builder().topicFilter(topic)).qos(this.getMqttQosFromInt(qos))).build();
        return this.client.subscribe(subscribeMessage, subscription::messageArrived);
    }

    @Override
    public CompletableFuture<?> unsubscribe(String topic) {
        Mqtt5Unsubscribe unsubscribeMessage = ((Mqtt5UnsubscribeBuilder.Complete)Mqtt5Unsubscribe.builder().topicFilter(topic)).build();
        return this.client.unsubscribe(unsubscribeMessage);
    }

    public CompletableFuture<Mqtt5PublishResult> publish(String topic, byte[] payload, boolean retain, int qos) {
        Mqtt5Publish publishMessage = ((Mqtt5PublishBuilder.Complete)((Mqtt5PublishBuilder.Complete)((Mqtt5PublishBuilder.Complete)((Mqtt5PublishBuilder.Complete)Mqtt5Publish.builder().topic(topic)).qos(this.getMqttQosFromInt(qos))).payload(payload)).retain(retain)).build();
        return this.client.publish(publishMessage);
    }

    @Override
    public CompletableFuture<?> connect(@Nullable MqttWillAndTestament lwt, int keepAliveInterval, @Nullable String username, @Nullable String password) {
        Mqtt5ConnectBuilder connectMessageBuilder = (Mqtt5ConnectBuilder)Mqtt5Connect.builder().keepAlive(keepAliveInterval);
        if (lwt != null) {
            Mqtt5Publish willPublish = ((Mqtt5PublishBuilder.Complete)((Mqtt5PublishBuilder.Complete)((Mqtt5PublishBuilder.Complete)((Mqtt5PublishBuilder.Complete)Mqtt5Publish.builder().topic(lwt.getTopic())).payload(lwt.getPayload())).retain(lwt.isRetain())).qos(this.getMqttQosFromInt(lwt.getQos()))).build();
            connectMessageBuilder.willPublish(willPublish);
        }
        if (username != null && !username.isBlank() && password != null && !password.isBlank()) {
            ((Mqtt5SimpleAuthBuilder.Nested.Complete)((Mqtt5SimpleAuthBuilder.Nested.Complete)connectMessageBuilder.simpleAuth().username(username)).password(password.getBytes())).applySimpleAuth();
        }
        return this.client.connect(connectMessageBuilder.build());
    }

    @Override
    public CompletableFuture<Void> disconnect() {
        return this.client.disconnect();
    }
}

