/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import java.util.Objects;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;

public class SqmTruthnessPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<?> expression;
    private final boolean value;

    public SqmTruthnessPredicate(SqmExpression<?> expression, boolean value, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.expression = expression;
        this.value = value;
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    @Override
    public SqmTruthnessPredicate copy(SqmCopyContext context) {
        SqmTruthnessPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTruthnessPredicate predicate = context.registerCopy(this, new SqmTruthnessPredicate((SqmExpression<?>)this.expression.copy(context), this.getBooleanValue(), this.isNegated(), this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    public SqmExpression<?> getExpression() {
        return this.expression;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitIsTruePredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.expression.appendHqlString(hql, context);
        hql.append(" is ");
        if (this.isNegated()) {
            hql.append("not ");
        }
        hql.append(this.getBooleanValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmTruthnessPredicate)) return false;
        SqmTruthnessPredicate that = (SqmTruthnessPredicate)object;
        if (this.isNegated() != that.isNegated()) return false;
        if (this.value != that.value) return false;
        if (!Objects.equals(this.expression, that.expression)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isNegated(), this.value, this.expression);
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmTruthnessPredicate(this.expression, this.getBooleanValue(), !this.isNegated(), this.nodeBuilder());
    }
}

