/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.util.HeaderToken;
import io.undertow.util.HeaderTokenParser;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public enum DigestAuthorizationToken implements HeaderToken
{
    USERNAME("username", true),
    REALM("realm", true),
    NONCE("nonce", true),
    DIGEST_URI("uri", true),
    RESPONSE("response", true),
    ALGORITHM("algorithm", true),
    CNONCE("cnonce", true),
    OPAQUE("opaque", true),
    MESSAGE_QOP("qop", true),
    NONCE_COUNT("nc", false),
    AUTH_PARAM("auth-param", false);

    private static final HeaderTokenParser<DigestAuthorizationToken> TOKEN_PARSER;
    private final String name;
    private final boolean quoted;

    private DigestAuthorizationToken(String name, boolean quoted) {
        this.name = name;
        this.quoted = quoted;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAllowQuoted() {
        return this.quoted;
    }

    public static Map<DigestAuthorizationToken, String> parseHeader(String header) {
        return TOKEN_PARSER.parseHeader(header);
    }

    static {
        LinkedHashMap<String, DigestAuthorizationToken> expected = new LinkedHashMap<String, DigestAuthorizationToken>(DigestAuthorizationToken.values().length);
        for (DigestAuthorizationToken current : DigestAuthorizationToken.values()) {
            expected.put(current.getName(), current);
        }
        TOKEN_PARSER = new HeaderTokenParser(Collections.unmodifiableMap(expected));
    }
}

