/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

class SessionFactorySettings {
    SessionFactorySettings() {
    }

    static Map<String, Object> getSettings(SessionFactoryOptions options, SessionFactoryServiceRegistry serviceRegistry) {
        Object reference;
        Map<String, Object> settings = serviceRegistry.requireService(ConfigurationService.class).getSettings();
        HashMap<String, Object> result = new HashMap<String, Object>(settings);
        if (!settings.containsKey("javax.persistence.validation.factory") && !settings.containsKey("jakarta.persistence.validation.factory") && (reference = options.getValidatorFactoryReference()) != null) {
            result.put("javax.persistence.validation.factory", reference);
            result.put("jakarta.persistence.validation.factory", reference);
        }
        return result;
    }

    static String getSessionFactoryName(SessionFactoryOptions options, SessionFactoryServiceRegistry serviceRegistry) {
        String nameFromAggregation;
        String sessionFactoryName = options.getSessionFactoryName();
        if (sessionFactoryName != null) {
            return sessionFactoryName;
        }
        LoadedConfig loadedConfig = serviceRegistry.requireService(CfgXmlAccessService.class).getAggregatedConfig();
        if (loadedConfig != null && (nameFromAggregation = loadedConfig.getSessionFactoryName()) != null) {
            return nameFromAggregation;
        }
        ConfigurationService configurationService = serviceRegistry.requireService(ConfigurationService.class);
        return configurationService.getSetting("hibernate.persistenceUnitName", StandardConverters.STRING);
    }

    static void maskOutSensitiveInformation(Map<String, Object> props) {
        SessionFactorySettings.maskOutIfSet(props, "javax.persistence.jdbc.user");
        SessionFactorySettings.maskOutIfSet(props, "javax.persistence.jdbc.password");
        SessionFactorySettings.maskOutIfSet(props, "jakarta.persistence.jdbc.user");
        SessionFactorySettings.maskOutIfSet(props, "jakarta.persistence.jdbc.password");
        SessionFactorySettings.maskOutIfSet(props, "hibernate.connection.username");
        SessionFactorySettings.maskOutIfSet(props, "hibernate.connection.password");
    }

    private static void maskOutIfSet(Map<String, Object> props, String setting) {
        if (props.containsKey(setting)) {
            props.put(setting, "****");
        }
    }

    static String determineJndiName(String name, SessionFactoryOptions options, SessionFactoryServiceRegistry serviceRegistry) {
        ConfigurationService configService = serviceRegistry.requireService(ConfigurationService.class);
        String explicitJndiName = configService.getSetting("hibernate.session_factory_jndi_name", StandardConverters.STRING);
        if (StringHelper.isNotEmpty(explicitJndiName)) {
            return explicitJndiName;
        }
        if (options.isSessionFactoryNameAlsoJndiName() == Boolean.FALSE) {
            return null;
        }
        String expliciSessionFactoryname = configService.getSetting("hibernate.session_factory_name", StandardConverters.STRING);
        if (StringHelper.isNotEmpty(expliciSessionFactoryname)) {
            return expliciSessionFactoryname;
        }
        String unitName = configService.getSetting("hibernate.persistenceUnitName", StandardConverters.STRING);
        return !StringHelper.isNotEmpty(unitName) ? name : null;
    }

    static void deprecationCheck(Map<String, Object> settings) {
        Iterator<String> iterator = settings.keySet().iterator();
        while (iterator.hasNext()) {
            String setting;
            switch (setting = iterator.next()) {
                case "hibernate.hql.bulk_id_strategy.global_temporary.create_tables": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.global_temporary.create_tables", "hibernate.query.mutation_strategy.global_temporary.create_tables");
                }
                case "hibernate.hql.bulk_id_strategy.global_temporary.drop_tables": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.global_temporary.drop_tables", "hibernate.query.mutation_strategy.global_temporary.drop_tables");
                }
                case "hibernate.hql.bulk_id_strategy.persistent.create_tables": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.persistent.create_tables", "hibernate.query.mutation_strategy.persistent.create_tables");
                }
                case "hibernate.hql.bulk_id_strategy.persistent.drop_tables": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.persistent.drop_tables", "hibernate.query.mutation_strategy.persistent.drop_tables");
                }
                case "hibernate.hql.bulk_id_strategy.persistent.schema": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.persistent.schema", "hibernate.query.mutation_strategy.persistent.schema");
                }
                case "hibernate.hql.bulk_id_strategy.persistent.catalog": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.persistent.catalog", "hibernate.query.mutation_strategy.persistent.catalog");
                }
                case "hibernate.hql.bulk_id_strategy.local_temporary.drop_tables": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.local_temporary.drop_tables", "hibernate.query.mutation_strategy.local_temporary.drop_tables");
                }
            }
        }
    }
}

