/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.vault.AbstractVaultProviderFactory;
import org.keycloak.vault.FilesKeystoreVaultProvider;
import org.keycloak.vault.VaultNotFoundException;
import org.keycloak.vault.VaultProvider;

public class FilesKeystoreVaultProviderFactory
extends AbstractVaultProviderFactory {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROVIDER_ID = "files-keystore";
    private Path keystoreFile;
    private String keystorePass;
    private String keystoreType;

    public VaultProvider create(KeycloakSession session) {
        if (this.keystoreFile == null) {
            logger.debug((Object)"Can not create a vault since it's not initialized correctly");
            return null;
        }
        return new FilesKeystoreVaultProvider(this.keystoreFile, this.keystorePass, this.keystoreType, this.getRealmName(session), this.keyResolvers);
    }

    @Override
    public void init(Config.Scope config) {
        super.init(config);
        String pathConfigProperty = config.get("file");
        if (pathConfigProperty == null) {
            logger.debug((Object)"Path to the vault keystore is not configured");
            return;
        }
        this.keystoreFile = Paths.get(pathConfigProperty, new String[0]);
        if (!Files.exists(this.keystoreFile, new LinkOption[0])) {
            throw new VaultNotFoundException("The vault does not exist on the path " + String.valueOf(this.keystoreFile.toAbsolutePath()));
        }
        this.keystorePass = config.get("pass");
        if (this.keystorePass == null) {
            logger.debug((Object)"Password for the vault keystore is not configured");
            return;
        }
        this.keystoreType = config.get("type", "PKCS12");
        logger.debugf("A type of the provided keystore is %s", (Object)this.keystoreType);
        logger.debugf("Configured KeystoreVaultProviderFactory with the keystore file located in %s", (Object)this.keystoreFile.toString());
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

