/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.concurrent.Executor;

public class UniRunSubscribeOn<I>
extends UniOperator<I, I> {
    private final Executor executor;

    public UniRunSubscribeOn(Uni<? extends I> upstream, Executor executor) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    @Override
    public void subscribe(UniSubscriber<? super I> subscriber) {
        try {
            this.executor.execute(() -> {
                try {
                    AbstractUni.subscribe(this.upstream(), new UniRunSubscribeOnProcessor(subscriber));
                }
                catch (Throwable woops) {
                    this.forwardFailure(subscriber, woops);
                }
            });
        }
        catch (Throwable err) {
            this.forwardFailure(subscriber, err);
        }
    }

    private void forwardFailure(UniSubscriber<? super I> subscriber, Throwable failure) {
        subscriber.onSubscribe(EmptyUniSubscription.DONE);
        subscriber.onFailure(failure);
    }

    private class UniRunSubscribeOnProcessor
    extends UniOperatorProcessor<I, I> {
        public UniRunSubscribeOnProcessor(UniSubscriber<? super I> downstream) {
            super(downstream);
        }
    }
}

