/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.settings;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Name;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

@MetadataDefinition
@Label(value="Period")
@Description(value="Record event at interval")
@Name(value="jdk.settings.Period")
public final class PeriodSetting
extends Control {
    private static final long typeId = Type.getTypeId(PeriodSetting.class);
    public static final String EVERY_CHUNK = "everyChunk";
    public static final String BEGIN_CHUNK = "beginChunk";
    public static final String END_CHUNK = "endChunk";
    public static final String NAME = "period";
    private final PlatformEventType eventType;
    private String value = "everyChunk";

    public PeriodSetting(PlatformEventType platformEventType, String string) {
        super(string);
        this.eventType = Objects.requireNonNull(platformEventType);
    }

    @Override
    public String combine(Set<String> set) {
        boolean bl = false;
        boolean bl2 = false;
        Long l = null;
        String string = null;
        Iterator<String> iterator = set.iterator();
        block10: while (iterator.hasNext()) {
            String string2;
            switch (string2 = iterator.next()) {
                case "everyChunk": {
                    bl = true;
                    bl2 = true;
                    continue block10;
                }
                case "beginChunk": {
                    bl = true;
                    continue block10;
                }
                case "endChunk": {
                    bl2 = true;
                    continue block10;
                }
            }
            long l2 = Utils.parseTimespanWithInfinity(string2);
            if (l == null) {
                string = string2;
                l = l2;
                continue;
            }
            if (l2 >= l) continue;
            string = string2;
            l = l2;
        }
        if (l != null) {
            return string;
        }
        if (bl && !bl2) {
            return BEGIN_CHUNK;
        }
        if (!bl && bl2) {
            return END_CHUNK;
        }
        return EVERY_CHUNK;
    }

    @Override
    public void setValue(String string) {
        switch (string) {
            case "everyChunk": {
                this.eventType.setPeriod(0L, true, true);
                break;
            }
            case "beginChunk": {
                this.eventType.setPeriod(0L, true, false);
                break;
            }
            case "endChunk": {
                this.eventType.setPeriod(0L, false, true);
                break;
            }
            default: {
                long l = Utils.parseTimespanWithInfinity(string);
                if (l != Long.MAX_VALUE) {
                    this.eventType.setPeriod(l / 1000000L, false, false);
                    break;
                }
                this.eventType.setPeriod(Long.MAX_VALUE, false, false);
            }
        }
        this.value = string;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static boolean isType(long l) {
        return typeId == l;
    }
}

