/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import kotlin.io.path.PathsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class GradleImprovedHotswapOutput {
    private static final Logger LOG = Logger.getInstance(GradleImprovedHotswapOutput.class);
    private static final String PATH_PREFIX = "path:";
    private static final String ROOT_PREFIX = "root:";
    private final String root;
    private final String path;

    private GradleImprovedHotswapOutput(String root, String path) {
        this.root = root;
        this.path = path;
    }

    public String getRoot() {
        return this.root;
    }

    public String getPath() {
        return this.path;
    }

    public static Collection<GradleImprovedHotswapOutput> parseOutputFile(Path file) {
        try {
            String content = PathsKt.readText((Path)file, (Charset)Charsets.UTF_8);
            Iterator lines = Arrays.stream(StringUtil.splitByLines((String)content, (boolean)true)).filter(line -> !line.isBlank()).iterator();
            ArrayList<GradleImprovedHotswapOutput> outputs = new ArrayList<GradleImprovedHotswapOutput>();
            while (lines.hasNext()) {
                String root = (String)lines.next();
                if (!lines.hasNext()) {
                    LOG.error("Expected Gradle Hotswap output to contain even number of lines");
                    LOG.debug("Gradle Hotswap output file:\n{}", new Object[]{content});
                    break;
                }
                String path = (String)lines.next();
                if (root.startsWith(ROOT_PREFIX) && path.startsWith(PATH_PREFIX)) {
                    outputs.add(new GradleImprovedHotswapOutput(root.substring(ROOT_PREFIX.length()), path.substring(PATH_PREFIX.length())));
                    continue;
                }
                LOG.error(String.format("Unexpected Gradle Hotswap output format. Expected '%s' to start with '%s' and '%s' to start with '%s'", root, ROOT_PREFIX, path, PATH_PREFIX));
            }
            return outputs;
        }
        catch (IOException e) {
            LOG.warn("Can not load temp file with collected Gradle tasks output paths", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

