/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.ui.painter.hints;

import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.ui.painter.PainterHint;
import org.jetbrains.jewel.ui.painter.hints.ColorBasedReplacementPainterSvgPatchHint;
import org.jetbrains.jewel.ui.util.ColorExtensionsKt;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u001a(\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u001a\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0014"}, d2={"patchPalette", "", "Lorg/w3c/dom/Element;", "fill", "", "Landroidx/compose/ui/graphics/Color;", "stroke", "patchColorAttribute", "attrName", "", "pattern", "tryParseColor", "color", "alpha", "", "fromHexOrNull", "rawColor", "ColorBasedPaletteReplacement", "Lorg/jetbrains/jewel/ui/painter/PainterHint;", "paletteMap", "intellij.platform.jewel.ui"})
@SourceDebugExtension(value={"SMAP\nColorBasedPaletteReplacement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorBasedPaletteReplacement.kt\norg/jetbrains/jewel/ui/painter/hints/ColorBasedPaletteReplacementKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class ColorBasedPaletteReplacementKt {
    public static final void patchPalette(@NotNull Element $this$patchPalette, @NotNull Map<Color, Color> fill, @NotNull Map<Color, Color> stroke) {
        Intrinsics.checkNotNullParameter((Object)$this$patchPalette, (String)"<this>");
        Intrinsics.checkNotNullParameter(fill, (String)"fill");
        Intrinsics.checkNotNullParameter(stroke, (String)"stroke");
        ColorBasedPaletteReplacementKt.patchColorAttribute($this$patchPalette, "fill", fill);
        ColorBasedPaletteReplacementKt.patchColorAttribute($this$patchPalette, "stroke", stroke);
        NodeList nodes = $this$patchPalette.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node item = nodes.item(i);
            if (!(item instanceof Element)) continue;
            ColorBasedPaletteReplacementKt.patchPalette((Element)item, fill, stroke);
        }
    }

    public static /* synthetic */ void patchPalette$default(Element element, Map map, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = map;
        }
        ColorBasedPaletteReplacementKt.patchPalette(element, map, map2);
    }

    private static final void patchColorAttribute(Element $this$patchColorAttribute, String attrName, Map<Color, Color> pattern) {
        String color = $this$patchColorAttribute.getAttribute(attrName);
        String opacity = $this$patchColorAttribute.getAttribute(attrName + "-opacity");
        Intrinsics.checkNotNull((Object)color);
        if (((CharSequence)color).length() > 0) {
            Intrinsics.checkNotNull((Object)opacity);
            Float f = StringsKt.toFloatOrNull((String)opacity);
            float alpha = f != null ? f.floatValue() : 1.0f;
            Color color2 = ColorBasedPaletteReplacementKt.tryParseColor(color, alpha);
            if (color2 == null) {
                return;
            }
            long originalColor = color2.unbox-impl();
            Color color3 = pattern.get(Color.box-impl((long)originalColor));
            if (color3 == null) {
                return;
            }
            long newColor = color3.unbox-impl();
            $this$patchColorAttribute.setAttribute(attrName, ColorExtensionsKt.toRgbaHexString-ek8zF_U$default(Color.copy-wmQWz5c$default((long)newColor, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null), false, true, 1, null));
            if (!(Color.getAlpha-impl((long)newColor) == alpha)) {
                $this$patchColorAttribute.setAttribute(attrName + "-opacity", String.valueOf(Color.getAlpha-impl((long)newColor)));
            }
        }
    }

    private static final Color tryParseColor(String color, float alpha) {
        String string = color.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String rawColor = string;
        if (StringsKt.startsWith$default((String)rawColor, (String)"#", (boolean)false, (int)2, null) && rawColor.length() - 1 <= 8) {
            return ColorBasedPaletteReplacementKt.fromHexOrNull(rawColor, alpha);
        }
        return null;
    }

    private static final Color fromHexOrNull(String rawColor, float alpha) {
        Integer n;
        int startPos = StringsKt.startsWith$default((String)rawColor, (String)"#", (boolean)false, (int)2, null) ? 1 : (StringsKt.startsWith$default((String)rawColor, (String)"0x", (boolean)false, (int)2, null) ? 2 : 0);
        int length = rawColor.length() - startPos;
        Float f = Float.valueOf(alpha);
        float it = ((Number)f).floatValue();
        boolean bl = false;
        Float f2 = !(it == 1.0f) ? f : null;
        if (f2 != null) {
            it = ((Number)f2).floatValue();
            boolean bl2 = false;
            n = MathKt.roundToInt((float)(it * (float)255));
        } else {
            n = null;
        }
        Integer alphaOverride = n;
        return switch (length) {
            case 3 -> {
                String v2 = rawColor.substring(startPos, startPos + 1);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                int v3 = Integer.parseInt(v2, CharsKt.checkRadix((int)16));
                String v4 = rawColor.substring(startPos + 1, startPos + 2);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"substring(...)");
                int v5 = Integer.parseInt(v4, CharsKt.checkRadix((int)16));
                String v6 = rawColor.substring(startPos + 2, startPos + 3);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"substring(...)");
                Integer v7 = alphaOverride;
                yield Color.box-impl((long)ColorKt.Color((int)v3, (int)v5, (int)Integer.parseInt(v6, CharsKt.checkRadix((int)16)), (int)(v7 != null ? v7 : 255)));
            }
            case 4 -> {
                int v16;
                String v9 = rawColor.substring(startPos, startPos + 1);
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"substring(...)");
                int v10 = Integer.parseInt(v9, CharsKt.checkRadix((int)16));
                String v11 = rawColor.substring(startPos + 1, startPos + 2);
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"substring(...)");
                int v12 = Integer.parseInt(v11, CharsKt.checkRadix((int)16));
                String v13 = rawColor.substring(startPos + 2, startPos + 3);
                Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"substring(...)");
                int v14 = Integer.parseInt(v13, CharsKt.checkRadix((int)16));
                Integer v15 = alphaOverride;
                if (v15 != null) {
                    v16 = v15;
                } else {
                    String v17 = rawColor.substring(startPos + 3, startPos + 4);
                    Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"substring(...)");
                    v16 = Integer.parseInt(v17, CharsKt.checkRadix((int)16));
                }
                yield Color.box-impl((long)ColorKt.Color((int)v10, (int)v12, (int)v14, (int)v16));
            }
            case 6 -> {
                String v18 = rawColor.substring(startPos, startPos + 2);
                Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"substring(...)");
                int v19 = Integer.parseInt(v18, CharsKt.checkRadix((int)16));
                String v20 = rawColor.substring(startPos + 2, startPos + 4);
                Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"substring(...)");
                int v21 = Integer.parseInt(v20, CharsKt.checkRadix((int)16));
                String v22 = rawColor.substring(startPos + 4, startPos + 6);
                Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"substring(...)");
                Integer v23 = alphaOverride;
                yield Color.box-impl((long)ColorKt.Color((int)v19, (int)v21, (int)Integer.parseInt(v22, CharsKt.checkRadix((int)16)), (int)(v23 != null ? v23 : 255)));
            }
            case 8 -> {
                int v31;
                String v24 = rawColor.substring(startPos, startPos + 2);
                Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"substring(...)");
                int v25 = Integer.parseInt(v24, CharsKt.checkRadix((int)16));
                String v26 = rawColor.substring(startPos + 2, startPos + 4);
                Intrinsics.checkNotNullExpressionValue((Object)v26, (String)"substring(...)");
                int v27 = Integer.parseInt(v26, CharsKt.checkRadix((int)16));
                String v28 = rawColor.substring(startPos + 4, startPos + 6);
                Intrinsics.checkNotNullExpressionValue((Object)v28, (String)"substring(...)");
                int v29 = Integer.parseInt(v28, CharsKt.checkRadix((int)16));
                Integer v30 = alphaOverride;
                if (v30 != null) {
                    v31 = v30;
                } else {
                    String v32 = rawColor.substring(startPos + 6, startPos + 8);
                    Intrinsics.checkNotNullExpressionValue((Object)v32, (String)"substring(...)");
                    v31 = Integer.parseInt(v32, CharsKt.checkRadix((int)16));
                }
                yield Color.box-impl((long)ColorKt.Color((int)v25, (int)v27, (int)v29, (int)v31));
            }
            default -> null;
        };
    }

    @NotNull
    public static final PainterHint ColorBasedPaletteReplacement(@NotNull Map<Color, Color> paletteMap) {
        Intrinsics.checkNotNullParameter(paletteMap, (String)"paletteMap");
        return paletteMap.isEmpty() ? (PainterHint)PainterHint.None : (PainterHint)new ColorBasedReplacementPainterSvgPatchHint(paletteMap);
    }
}

