/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.move;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.util.GroovyChangeContextUtil;

public final class MoveGroovyFileHandler
extends MoveFileHandler {
    private static final Logger LOG = Logger.getInstance(MoveGroovyFileHandler.class);

    public boolean canProcessElement(PsiFile element) {
        return element instanceof GroovyFile;
    }

    public void prepareMovedFile(PsiFile file, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewMap) {
        GroovyFile groovyFile = (GroovyFile)file;
        GroovyChangeContextUtil.encodeContextInfo(groovyFile);
        for (PsiClass psiClass : groovyFile.getClasses()) {
            oldToNewMap.put((PsiElement)psiClass, (PsiElement)MoveClassesOrPackagesUtil.doMoveClass((PsiClass)psiClass, (PsiDirectory)moveDestination));
        }
    }

    @Nullable
    public @Unmodifiable List<UsageInfo> findUsages(@NotNull PsiFile psiFile, @NotNull PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        if (psiFile == null) {
            MoveGroovyFileHandler.$$$reportNull$$$0(0);
        }
        if (newParent == null) {
            MoveGroovyFileHandler.$$$reportNull$$$0(1);
        }
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        PsiPackage newParentPackage = JavaDirectoryService.getInstance().getPackage(newParent);
        String qualifiedName = newParentPackage == null ? "" : newParentPackage.getQualifiedName();
        for (PsiClass aClass : ((GroovyFile)psiFile).getClasses()) {
            Collections.addAll(result2, MoveClassesOrPackagesUtil.findUsages((PsiElement)aClass, (boolean)searchInComments, (boolean)searchInNonJavaFiles, (String)StringUtil.getQualifiedName((String)qualifiedName, (String)StringUtil.notNullize((String)aClass.getName()))));
        }
        return result2.isEmpty() ? null : result2;
    }

    public void retargetUsages(@Unmodifiable @NotNull List<? extends UsageInfo> usageInfos, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        if (usageInfos == null) {
            MoveGroovyFileHandler.$$$reportNull$$$0(2);
        }
        if (oldToNewMap == null) {
            MoveGroovyFileHandler.$$$reportNull$$$0(3);
        }
        for (UsageInfo usageInfo : usageInfos) {
            if (!(usageInfo instanceof MoveRenameUsageInfo)) continue;
            MoveRenameUsageInfo moveRenameUsage = (MoveRenameUsageInfo)usageInfo;
            PsiElement oldElement = moveRenameUsage.getReferencedElement();
            PsiElement newElement = oldToNewMap.get(oldElement);
            PsiReference reference = moveRenameUsage.getReference();
            if (reference == null) continue;
            try {
                LOG.assertTrue(newElement != null, oldElement != null ? oldElement : reference);
                reference.bindToElement(newElement);
            }
            catch (IncorrectOperationException ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    public void updateMovedFile(PsiFile file) throws IncorrectOperationException {
        GroovyChangeContextUtil.decodeContextInfo((PsiElement)file, null, null);
        PsiDirectory containingDirectory = file.getContainingDirectory();
        if (containingDirectory == null) {
            return;
        }
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory);
        if (aPackage == null) {
            return;
        }
        String qualifiedName = aPackage.getQualifiedName();
        if (file instanceof GroovyFile) {
            ((GroovyFile)file).setPackageName(qualifiedName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldToNewMap";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/move/MoveGroovyFileHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "retargetUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

