/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class _Private_RecyclingQueue<T> {
    private final ElementIterator iterator;
    private final List<T> elements;
    private final ElementFactory<T> elementFactory;
    private int currentIndex;
    private T top;

    public _Private_RecyclingQueue(int initialCapacity, ElementFactory<T> elementFactory) {
        this.elements = new ArrayList<T>(initialCapacity);
        this.elementFactory = elementFactory;
        this.currentIndex = -1;
        this.iterator = new ElementIterator();
    }

    public void truncate(int index) {
        this.currentIndex = index;
    }

    public T get(int index) {
        return this.elements.get(index);
    }

    public int push(Recycler<T> recycler) {
        ++this.currentIndex;
        if (this.currentIndex >= this.elements.size()) {
            this.top = this.elementFactory.newElement();
            this.elements.add(this.top);
        } else {
            this.top = this.elements.get(this.currentIndex);
        }
        recycler.recycle(this.top);
        return this.currentIndex;
    }

    public void remove() {
        this.currentIndex = Math.max(-1, this.currentIndex - 1);
    }

    public Iterator<T> iterate() {
        this.iterator.i = 0;
        return this.iterator;
    }

    public boolean isEmpty() {
        return this.currentIndex < 0;
    }

    public void clear() {
        this.currentIndex = -1;
    }

    public int size() {
        return this.currentIndex + 1;
    }

    private class ElementIterator
    implements Iterator<T> {
        int i = 0;

        private ElementIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i <= _Private_RecyclingQueue.this.currentIndex;
        }

        @Override
        public T next() {
            return _Private_RecyclingQueue.this.elements.get(this.i++);
        }
    }

    @FunctionalInterface
    public static interface Recycler<T> {
        public void recycle(T var1);
    }

    public static interface ElementFactory<T> {
        public T newElement();
    }
}

