/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.changes.ui.LoadingCommittedChangeListPanel;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitBranch;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.i18n.GitBundleExtensions;
import git4idea.merge.CommitMessagePreview;
import git4idea.merge.MergeConflictMultipleCommitInfoDialog;
import git4idea.merge.RefInfo;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u00012\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0001\u001a\"\u0010\b\u001a\u00070\u0001\u00a2\u0006\u0002\b\t2\u000b\u0010\n\u001a\u00070\u0001\u00a2\u0006\u0002\b\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u00012\b\b\u0001\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0010\u001a\u00020\u00012\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0003\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0018\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0001\u001a!\u0010\u001c\u001a\r\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\t0\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0002\u001a\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0001\u001a!\u0010\u001f\u001a\r\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\t0\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0002\u001a,\u0010 \u001a\u00020!2\b\b\u0001\u0010\"\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020\u0001H\u0000\u001a@\u0010&\u001a\u00020!2\b\b\u0001\u0010\"\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$2\u001c\u0010'\u001a\u0018\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\t\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\t0(H\u0000\u001a \u0010)\u001a\u00020*2\b\b\u0001\u0010\"\u001a\u00020\u00012\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0000\u001a\f\u0010.\u001a\u00020/*\u000200H\u0002\u00a8\u00061"}, d2={"getDescriptionForRebase", "", "repository", "Lgit4idea/repo/GitRepository;", "rebasingBranch", "baseBranch", "baseHash", "Lcom/intellij/vcs/log/Hash;", "appendCommitMessageToRebaseConflictDescription", "Lcom/intellij/openapi/util/NlsSafe;", "description", "Lorg/jetbrains/annotations/Nls;", "conflictOnCommit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "getDefaultLeftPanelTitleForBranch", "branchName", "getDefaultRightPanelTitleForBranch", "resolveMergeBranchOrCherryPick", "resolveMergeBranch", "Lgit4idea/merge/RefInfo;", "resolveRebaseOntoBranch", "resolveBranchName", "hash", "tryResolveRef", "ref", "getSingleMergeBranchName", "roots", "", "getMergeBranchNameSet", "", "getSingleCurrentBranchName", "getCurrentBranchNameSet", "getTitleWithCommitDetailsCustomizer", "Lcom/intellij/diff/DiffEditorTitleCustomizer;", "title", "file", "Lcom/intellij/openapi/vcs/FilePath;", "commit", "getTitleWithCommitsRangeDetailsCustomizer", "range", "Lkotlin/Pair;", "getTitleWithShowDetailsAction", "Ljavax/swing/JPanel;", "action", "Lkotlin/Function0;", "", "toInt", "", "", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitDefaultMergeDialogCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDefaultMergeDialogCustomizer.kt\ngit4idea/merge/GitDefaultMergeDialogCustomizerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,430:1\n1617#2,9:431\n1869#2:440\n1870#2:442\n1626#2:443\n1#3:441\n1#3:444\n*S KotlinDebug\n*F\n+ 1 GitDefaultMergeDialogCustomizer.kt\ngit4idea/merge/GitDefaultMergeDialogCustomizerKt\n*L\n298#1:431,9\n298#1:440\n298#1:442\n298#1:443\n298#1:441\n*E\n"})
public final class GitDefaultMergeDialogCustomizerKt {
    @NlsContexts.Label
    @NotNull
    public static final String getDescriptionForRebase(@Nullable GitRepository repository2, @NlsSafe @Nullable String rebasingBranch, @NlsSafe @Nullable String baseBranch, @Nullable Hash baseHash) {
        String string;
        VcsCommitMetadata conflictOnCommit;
        String string2;
        if (baseBranch != null) {
            var6_4 = new Object[5];
            var6_4[0] = GitDefaultMergeDialogCustomizerKt.toInt(rebasingBranch != null);
            String string3 = rebasingBranch;
            if (string3 == null) {
                string3 = "";
            }
            var6_4[1] = HtmlChunk.text((String)string3).bold();
            var6_4[2] = HtmlChunk.text((String)baseBranch).bold();
            var6_4[3] = GitDefaultMergeDialogCustomizerKt.toInt(baseHash != null);
            Object object = baseHash;
            if (object == null || (object = object.toShortString()) == null) {
                object = "";
            }
            var6_4[4] = object;
            string2 = GitBundle.message((String)"merge.dialog.description.rebase.with.onto.branch.label.text", (Object[])var6_4);
        } else if (baseHash != null) {
            var6_4 = new Object[3];
            var6_4[0] = GitDefaultMergeDialogCustomizerKt.toInt(rebasingBranch != null);
            String string4 = rebasingBranch;
            if (string4 == null) {
                string4 = "";
            }
            var6_4[1] = HtmlChunk.text((String)string4).bold();
            var6_4[2] = HtmlChunk.text((String)baseHash.toShortString()).bold();
            string2 = GitBundle.message((String)"merge.dialog.description.rebase.with.hash.label.text", (Object[])var6_4);
        } else {
            var6_4 = new Object[2];
            var6_4[0] = GitDefaultMergeDialogCustomizerKt.toInt(rebasingBranch != null);
            String string5 = rebasingBranch;
            if (string5 == null) {
                string5 = "";
            }
            var6_4[1] = HtmlChunk.text((String)string5).bold();
            string2 = GitBundle.message((String)"merge.dialog.description.rebase.without.onto.info.label.text", (Object[])var6_4);
        }
        String string6 = string2;
        Intrinsics.checkNotNull((Object)string6);
        String description = string6;
        GitRepository gitRepository = repository2;
        if (gitRepository != null) {
            List<? extends VcsCommitMetadata> list = GitLogUtil.collectMetadata(gitRepository.getProject(), repository2.getRoot(), CollectionsKt.listOf((Object)"REBASE_HEAD"));
            Intrinsics.checkNotNullExpressionValue(list, (String)"collectMetadata(...)");
            v7 = (VcsCommitMetadata)CollectionsKt.singleOrNull(list);
        } else {
            v7 = conflictOnCommit = null;
        }
        if (conflictOnCommit == null) {
            String string7 = HtmlChunk.raw((String)description).toString();
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
        } else {
            string = GitDefaultMergeDialogCustomizerKt.appendCommitMessageToRebaseConflictDescription(description, conflictOnCommit);
        }
        return string;
    }

    private static final String appendCommitMessageToRebaseConflictDescription(String description, VcsCommitMetadata conflictOnCommit) {
        Object[] objectArray = new Object[]{HtmlChunk.text((String)((Hash)conflictOnCommit.getId()).toShortString()).code(), conflictOnCommit.getAuthor().getName()};
        String string = GitBundle.message((String)"merge.dialog.description.rebase.conflict.current.commit", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String currentCommitDetails = string;
        HtmlBuilder htmlBuilder = new HtmlBuilder().append(HtmlChunk.raw((String)(description + ". " + currentCommitDetails))).br();
        String string2 = conflictOnCommit.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFullMessage(...)");
        String string3 = htmlBuilder.append((HtmlChunk)CommitMessagePreview.INSTANCE.asHtmlChunk(string2)).wrapWith(HtmlChunk.html()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    @NotNull
    public static final String getDefaultLeftPanelTitleForBranch(@NlsSafe @NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)branchName).bold(), (String)"bold(...)");
        return GitBundleExtensions.html("merge.dialog.diff.left.title.default.branch.label.text", objectArray);
    }

    @NotNull
    public static final String getDefaultRightPanelTitleForBranch(@NlsSafe @Nullable String branchName, @Nullable Hash baseHash) {
        String string;
        if (branchName != null) {
            Object[] objectArray = new Object[3];
            Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)branchName).bold(), (String)"bold(...)");
            objectArray[1] = GitDefaultMergeDialogCustomizerKt.toInt(baseHash != null);
            Object object = baseHash;
            if (object == null || (object = object.toShortString()) == null) {
                object = "";
            }
            objectArray[2] = object;
            string = GitBundleExtensions.html("merge.dialog.diff.right.title.default.with.onto.branch.label.text", objectArray);
        } else if (baseHash != null) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)baseHash.toShortString()).bold(), (String)"bold(...)");
            string = GitBundleExtensions.html("merge.dialog.diff.right.title.default.with.hash.label.text", objectArray);
        } else {
            String string2 = GitBundle.message((String)"merge.dialog.diff.right.title.default.without.onto.info.label.text", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        return string;
    }

    @NlsSafe
    private static final String resolveMergeBranchOrCherryPick(GitRepository repository2) {
        RefInfo mergeBranch = GitDefaultMergeDialogCustomizerKt.resolveMergeBranch(repository2);
        if (mergeBranch != null) {
            return mergeBranch.getPresentable();
        }
        RefInfo rebaseOntoBranch = GitDefaultMergeDialogCustomizerKt.resolveRebaseOntoBranch(repository2);
        if (rebaseOntoBranch != null) {
            return rebaseOntoBranch.getPresentable();
        }
        Hash cherryHead = GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository2, "CHERRY_PICK_HEAD");
        if (cherryHead != null) {
            return "cherry-pick";
        }
        return null;
    }

    private static final RefInfo resolveMergeBranch(GitRepository repository2) {
        Hash hash = GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository2, "MERGE_HEAD");
        if (hash == null) {
            return null;
        }
        Hash mergeHead = hash;
        return GitDefaultMergeDialogCustomizerKt.resolveBranchName(repository2, mergeHead);
    }

    private static final RefInfo resolveRebaseOntoBranch(GitRepository repository2) {
        Hash hash = GitRebaseUtils.getOntoHash(repository2.getProject(), repository2.getRoot());
        if (hash == null) {
            return null;
        }
        Hash ontoHash = hash;
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(repository2.getProject()).getRepositoryForRoot(repository2.getRoot());
        if (gitRepository == null) {
            return null;
        }
        GitRepository repo = gitRepository;
        return GitDefaultMergeDialogCustomizerKt.resolveBranchName(repo, ontoHash);
    }

    private static final RefInfo resolveBranchName(GitRepository repository2, Hash hash) {
        Collection<GitLocalBranch> collection = repository2.getBranches().findLocalBranchesByHash(hash);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"findLocalBranchesByHash(...)");
        Collection<GitLocalBranch> branches = collection;
        if (branches.isEmpty()) {
            Collection<GitRemoteBranch> collection2 = repository2.getBranches().findRemoteBranchesByHash(hash);
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"findRemoteBranchesByHash(...)");
            branches = collection2;
        }
        GitBranch gitBranch = (GitBranch)CollectionsKt.singleOrNull((Iterable)branches);
        return new RefInfo(hash, gitBranch != null ? gitBranch.getName() : null);
    }

    private static final Hash tryResolveRef(GitRepository repository2, @NlsSafe String ref) {
        try {
            GitRevisionNumber gitRevisionNumber = GitRevisionNumber.resolve(repository2.getProject(), repository2.getRoot(), ref);
            Intrinsics.checkNotNullExpressionValue((Object)gitRevisionNumber, (String)"resolve(...)");
            GitRevisionNumber revision = gitRevisionNumber;
            return HashImpl.build((String)revision.asString());
        }
        catch (VcsException e) {
            return null;
        }
    }

    @NlsSafe
    @Nullable
    public static final String getSingleMergeBranchName(@NotNull Collection<? extends GitRepository> roots) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        return (String)CollectionsKt.singleOrNull((Iterable)GitDefaultMergeDialogCustomizerKt.getMergeBranchNameSet(roots));
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> getMergeBranchNameSet(Collection<? extends GitRepository> roots) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = roots;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GitRepository repo = (GitRepository)element$iv$iv;
            boolean bl2 = false;
            if (GitDefaultMergeDialogCustomizerKt.resolveMergeBranchOrCherryPick(repo) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NlsSafe
    @Nullable
    public static final String getSingleCurrentBranchName(@NotNull Collection<? extends GitRepository> roots) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        return (String)CollectionsKt.singleOrNull((Iterable)GitDefaultMergeDialogCustomizerKt.getCurrentBranchNameSet(roots));
    }

    private static final Set<String> getCurrentBranchNameSet(Collection<? extends GitRepository> roots) {
        return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)roots), GitDefaultMergeDialogCustomizerKt::getCurrentBranchNameSet$lambda$2));
    }

    @NotNull
    public static final DiffEditorTitleCustomizer getTitleWithCommitDetailsCustomizer(@Nls @NotNull String title, @NotNull GitRepository repository2, @NotNull FilePath file, @NlsSafe @NotNull String commit) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        return () -> GitDefaultMergeDialogCustomizerKt.getTitleWithCommitDetailsCustomizer$lambda$5(title, repository2, commit, file);
    }

    @NotNull
    public static final DiffEditorTitleCustomizer getTitleWithCommitsRangeDetailsCustomizer(@NlsContexts.Label @NotNull String title, @NotNull GitRepository repository2, @NotNull FilePath file, @NotNull Pair<String, String> range) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        return () -> GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer$lambda$10(title, repository2, range, file);
    }

    @NotNull
    public static final JPanel getTitleWithShowDetailsAction(@Nls @NotNull String title, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel().addToCenter((Component)new JBLabel(title).setCopyable(true));
        String string = GitBundle.message((String)"merge.dialog.customizer.show.details.link.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel.addToRight((Component)new ActionLink(string, arg_0 -> GitDefaultMergeDialogCustomizerKt.getTitleWithShowDetailsAction$lambda$11(action, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel2, (String)"addToRight(...)");
        return (JPanel)borderLayoutPanel2;
    }

    private static final int toInt(boolean $this$toInt) {
        return $this$toInt ? 1 : 0;
    }

    private static final String getCurrentBranchNameSet$lambda$2(GitRepository repo) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        String string = repo.getCurrentBranchName();
        if (string == null) {
            String string2 = repo.getCurrentRevision();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                string = VcsLogUtil.getShortHash((String)it);
            } else {
                string = null;
            }
        }
        return string;
    }

    private static final LoadingCommittedChangeListPanel.ChangelistData getTitleWithCommitDetailsCustomizer$lambda$5$lambda$4$lambda$3(GitRepository $repository, String $commit, FilePath $file) {
        GitCommittedChangeList changeList = GitChangeUtils.getRevisionChanges($repository.getProject(), $repository.getRoot(), $commit, true, false, false);
        return new LoadingCommittedChangeListPanel.ChangelistData((CommittedChangeList)changeList, $file);
    }

    private static final Unit getTitleWithCommitDetailsCustomizer$lambda$5$lambda$4(GitRepository $repository, String $title, String $commit, FilePath $file) {
        LoadingCommittedChangeListPanel panel2 = new LoadingCommittedChangeListPanel($repository.getProject());
        panel2.loadChangesInBackground(() -> GitDefaultMergeDialogCustomizerKt.getTitleWithCommitDetailsCustomizer$lambda$5$lambda$4$lambda$3($repository, $commit, $file));
        ChangeListViewerDialog dlg = new ChangeListViewerDialog($repository.getProject(), panel2);
        dlg.setTitle(StringUtil.stripHtml((String)$title, (boolean)false));
        dlg.setModal(true);
        dlg.show();
        return Unit.INSTANCE;
    }

    private static final JComponent getTitleWithCommitDetailsCustomizer$lambda$5(String $title, GitRepository $repository, String $commit, FilePath $file) {
        return GitDefaultMergeDialogCustomizerKt.getTitleWithShowDetailsAction($title, (Function0<Unit>)((Function0)() -> GitDefaultMergeDialogCustomizerKt.getTitleWithCommitDetailsCustomizer$lambda$5$lambda$4($repository, $title, $commit, $file)));
    }

    private static final Unit getTitleWithCommitsRangeDetailsCustomizer$lambda$10$lambda$9$lambda$8$lambda$6(FilePath $file, HashSet $filteredCommits, List $details, GitCommit commit) {
        VcsCommitMetadataImpl commitMetadata = new VcsCommitMetadataImpl(commit.getId(), commit.getParents(), commit.getCommitTime(), commit.getRoot(), commit.getSubject(), commit.getAuthor(), commit.getFullMessage(), commit.getCommitter(), commit.getAuthorTime());
        if (commit.getAffectedPaths().contains($file)) {
            $filteredCommits.add(commitMetadata);
        }
        $details.add(commitMetadata);
        return Unit.INSTANCE;
    }

    private static final void getTitleWithCommitsRangeDetailsCustomizer$lambda$10$lambda$9$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void getTitleWithCommitsRangeDetailsCustomizer$lambda$10$lambda$9$lambda$8(GitRepository $repository, Pair $range, FilePath $file, HashSet $filteredCommits, List $details) {
        String[] stringArray = new String[]{$range.getFirst() + ".." + $range.getSecond()};
        GitLogUtil.readFullDetails($repository.getProject(), $repository.getRoot(), arg_0 -> GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer$lambda$10$lambda$9$lambda$8$lambda$7(arg_0 -> GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer$lambda$10$lambda$9$lambda$8$lambda$6($file, $filteredCommits, $details, arg_0), arg_0), stringArray);
    }

    private static final Unit getTitleWithCommitsRangeDetailsCustomizer$lambda$10$lambda$9(GitRepository $repository, String $title, Pair $range, FilePath $file) {
        List details = new ArrayList();
        HashSet filteredCommits = new HashSet();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer$lambda$10$lambda$9$lambda$8($repository, $range, $file, filteredCommits, details), GitBundle.message((String)"merge.dialog.customizer.collecting.details.progress", (Object[])new Object[0]), true, $repository.getProject());
        Project project = $repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = $repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        MergeConflictMultipleCommitInfoDialog dlg = new MergeConflictMultipleCommitInfoDialog(project, virtualFile, details, filteredCommits);
        dlg.setTitle(StringUtil.stripHtml((String)$title, (boolean)false));
        dlg.show();
        return Unit.INSTANCE;
    }

    private static final JComponent getTitleWithCommitsRangeDetailsCustomizer$lambda$10(String $title, GitRepository $repository, Pair $range, FilePath $file) {
        return GitDefaultMergeDialogCustomizerKt.getTitleWithShowDetailsAction($title, (Function0<Unit>)((Function0)() -> GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer$lambda$10$lambda$9($repository, $title, $range, $file)));
    }

    private static final Unit getTitleWithShowDetailsAction$lambda$11(Function0 $action, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $action.invoke();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Set access$getCurrentBranchNameSet(Collection roots) {
        return GitDefaultMergeDialogCustomizerKt.getCurrentBranchNameSet(roots);
    }

    public static final /* synthetic */ int access$toInt(boolean $receiver) {
        return GitDefaultMergeDialogCustomizerKt.toInt($receiver);
    }

    public static final /* synthetic */ Hash access$tryResolveRef(GitRepository repository2, String ref) {
        return GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository2, ref);
    }

    public static final /* synthetic */ RefInfo access$resolveMergeBranch(GitRepository repository2) {
        return GitDefaultMergeDialogCustomizerKt.resolveMergeBranch(repository2);
    }

    public static final /* synthetic */ RefInfo access$resolveRebaseOntoBranch(GitRepository repository2) {
        return GitDefaultMergeDialogCustomizerKt.resolveRebaseOntoBranch(repository2);
    }
}

