/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.providers.bounds.JupyterBoundsChangeHandler;
import com.intellij.notebooks.visualization.ui.providers.bounds.JupyterBoundsChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/notebooks/visualization/ui/NotebookVisibleCellsBatchUpdater;", "Lcom/intellij/openapi/Disposable$Default;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "prevVisibleCells", "", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "isCellVisible", "", "cell", "getCellRectangle", "Ljava/awt/Rectangle;", "updateVisibleCells", "", "Companion", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookVisibleCellsBatchUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookVisibleCellsBatchUpdater.kt\ncom/intellij/notebooks/visualization/ui/NotebookVisibleCellsBatchUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1869#2,2:119\n1869#2,2:121\n1869#2,2:123\n*S KotlinDebug\n*F\n+ 1 NotebookVisibleCellsBatchUpdater.kt\ncom/intellij/notebooks/visualization/ui/NotebookVisibleCellsBatchUpdater\n*L\n73#1:119,2\n99#1:121,2\n102#1:123,2\n*E\n"})
public final class NotebookVisibleCellsBatchUpdater
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private List<EditorCell> prevVisibleCells;
    @NotNull
    private static final Key<NotebookVisibleCellsBatchUpdater> INSTANCE_KEY;

    public NotebookVisibleCellsBatchUpdater(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.prevVisibleCells = CollectionsKt.emptyList();
        JupyterBoundsChangeHandler.Companion.get((Editor)this.editor).subscribe((Disposable)this, new JupyterBoundsChangeListener(){

            public void boundsChanged() {
                this.updateVisibleCells();
            }
        });
        this.editor.getScrollingModel().addVisibleAreaListener(arg_0 -> NotebookVisibleCellsBatchUpdater._init_$lambda$0(this, arg_0), (Disposable)this);
        this.updateVisibleCells();
    }

    public final boolean isCellVisible(@NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        boolean cached = this.prevVisibleCells.contains(cell);
        if (cached) {
            return true;
        }
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        if (visibleArea.height == 0 || visibleArea.width == 0) {
            return false;
        }
        Rectangle rectangle2 = this.getCellRectangle(cell);
        if (rectangle2 == null) {
            return false;
        }
        Rectangle cellRectangle = rectangle2;
        return visibleArea.intersects(cellRectangle);
    }

    private final Rectangle getCellRectangle(EditorCell cell) {
        NotebookCellLines.Interval interval = cell.getIntervalOrNull();
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        int firstLineWithOverlap = Math.max(interval2.getFirstContentLine() - 1, 0);
        int lastLineWithOverlap = Math.min(interval2.getLastContentLine() + 1, this.editor.getDocument().getLineCount());
        int startY = this.editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)firstLineWithOverlap, (int)0)).y;
        int endY = this.editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)lastLineWithOverlap, (int)0)).y + this.editor.getLineHeight();
        Rectangle cellRectangle = new Rectangle(0, startY, this.editor.getComponent().getWidth(), endY - startY);
        return cellRectangle;
    }

    private final void updateVisibleCells() {
        EditorCell it;
        NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get((Editor)this.editor);
        if (notebookCellInlayManager == null) {
            return;
        }
        NotebookCellInlayManager inlayManager = notebookCellInlayManager;
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        if (visibleArea.height == 0 || visibleArea.width == 0) {
            Iterable $this$forEach$iv = this.prevVisibleCells;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorCell it2 = (EditorCell)element$iv;
                boolean bl = false;
            }
            this.prevVisibleCells = CollectionsKt.emptyList();
            return;
        }
        int firstVisibleLine = Math.max(this.editor.xyToLogicalPosition((Point)new Point((int)0, (int)visibleArea.y)).line, 0);
        int lastVisibleLine = Math.min(this.editor.xyToLogicalPosition((Point)new Point((int)0, (int)(visibleArea.y + visibleArea.height))).line + 1, this.editor.getDocument().getLineCount() - 1);
        List visibleCells = new ArrayList();
        for (EditorCell cell : inlayManager.getCells()) {
            int firstLine = cell.getInterval().getFirstContentLine();
            int lastLine = cell.getInterval().getLastContentLine();
            if (lastLine < firstVisibleLine) continue;
            if (firstLine > lastVisibleLine) break;
            visibleCells.add(cell);
        }
        if (Intrinsics.areEqual((Object)visibleCells, this.prevVisibleCells)) {
            return;
        }
        List newInvisible = CollectionsKt.minus((Iterable)this.prevVisibleCells, (Iterable)visibleCells);
        List newVisible = CollectionsKt.minus((Iterable)visibleCells, (Iterable)this.prevVisibleCells);
        Iterable $this$forEach$iv = newInvisible;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (EditorCell)element$iv;
            boolean bl = false;
        }
        $this$forEach$iv = newVisible;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (EditorCell)element$iv;
            boolean bl = false;
        }
        this.prevVisibleCells = visibleCells;
    }

    private static final void _init_$lambda$0(NotebookVisibleCellsBatchUpdater this$0, VisibleAreaEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)it.getNewRectangle(), (Object)it.getOldRectangle())) {
            return;
        }
        this$0.updateVisibleCells();
    }

    static {
        Key key = Key.create((String)"EDITOR_CELL_FRAME_UPDATER_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        INSTANCE_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/notebooks/visualization/ui/NotebookVisibleCellsBatchUpdater$Companion;", "", "<init>", "()V", "INSTANCE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/notebooks/visualization/ui/NotebookVisibleCellsBatchUpdater;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

