/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.r.inlays;

import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\n\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lcom/intellij/notebooks/visualization/r/inlays/ClipboardUtils;", "", "<init>", "()V", "copyImageToClipboard", "", "image", "Ljava/awt/Image;", "copyPngImageToClipboard", "Ljava/awt/image/BufferedImage;", "FileTransferable", "ImageTransferable", "intellij.notebooks.visualization"})
public final class ClipboardUtils {
    @NotNull
    public static final ClipboardUtils INSTANCE = new ClipboardUtils();

    private ClipboardUtils() {
    }

    public final void copyImageToClipboard(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        CopyPasteManager.getInstance().setContents((Transferable)new ImageTransferable(image));
    }

    public final void copyPngImageToClipboard(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        File file = FileUtil.createTempFile((String)"clipboard", (String)".png");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File tempImage = file;
        ImageIO.write((RenderedImage)image, "png", tempImage);
        CopyPasteManager.getInstance().setContents((Transferable)new FileTransferable(CollectionsKt.listOf((Object)tempImage)));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\r\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/notebooks/visualization/r/inlays/ClipboardUtils$FileTransferable;", "Ljava/awt/datatransfer/Transferable;", "files", "", "Ljava/io/File;", "<init>", "(Ljava/util/List;)V", "getTransferDataFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "flavor", "getTransferData", "intellij.notebooks.visualization"})
    private static final class FileTransferable
    implements Transferable {
        @NotNull
        private final List<File> files;

        public FileTransferable(@NotNull List<? extends File> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            this.files = files;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[1];
            Intrinsics.checkNotNullExpressionValue((Object)DataFlavor.javaFileListFlavor, (String)"javaFileListFlavor");
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            return DataFlavor.javaFileListFlavor.equals(flavor);
        }

        @Override
        @NotNull
        public List<File> getTransferData(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.files;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/notebooks/visualization/r/inlays/ClipboardUtils$ImageTransferable;", "Ljava/awt/datatransfer/Transferable;", "image", "Ljava/awt/Image;", "<init>", "(Ljava/awt/Image;)V", "getTransferDataFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "flavor", "getTransferData", "", "intellij.notebooks.visualization"})
    private static final class ImageTransferable
    implements Transferable {
        @NotNull
        private final Image image;

        public ImageTransferable(@NotNull Image image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[1];
            Intrinsics.checkNotNullExpressionValue((Object)DataFlavor.imageFlavor, (String)"imageFlavor");
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            return Intrinsics.areEqual((Object)flavor, (Object)DataFlavor.imageFlavor);
        }

        @Override
        @NotNull
        public Object getTransferData(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

