/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model.pipeline;

import com.jetbrains.ml.api.feature.preprocessor.FeaturePreprocessor;
import com.jetbrains.ml.tools.model.MLModel;
import com.jetbrains.ml.tools.model.pipeline.Components;
import com.jetbrains.ml.tools.model.pipeline.ModelLoadingException;
import com.jetbrains.ml.tools.model.pipeline.ModelPipeline;
import com.jetbrains.ml.tools.model.pipeline.ModelPipelineLoader;
import com.jetbrains.ml.tools.model.pipeline.ThisThreadExecutorService;
import com.jetbrains.ml.tools.model.pipeline.VFSNode;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J2\u0010\u0007\u001a\u001e\u0012\u001a\u0012\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\n\u0012\u0004\u0012\u00020\u00010\tj\u0002`\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ2\u0010\u0007\u001a\u001e\u0012\u001a\u0012\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\n\u0012\u0004\u0012\u00020\u00010\tj\u0002`\u000b0\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0012\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\n\u0012\u0004\u0012\u00020\u00010\tj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rJ$\u0010\u0012\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\n\u0012\u0004\u0012\u00020\u00010\tj\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J(\u0010\u0013\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\tj\u0004\u0018\u0001`\u000b2\u0006\u0010\f\u001a\u00020\rJ(\u0010\u0013\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\tj\u0004\u0018\u0001`\u000b2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/ml/tools/model/pipeline/ModelPipelineLoader;", "", "()V", "isPipelineVersionSupported", "", "version", "", "load", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/ml/tools/model/pipeline/ModelPipeline;", "Lcom/jetbrains/ml/tools/model/MLModel;", "Lcom/jetbrains/ml/tools/model/pipeline/AnyModelPipeline;", "inputStream", "Ljava/io/InputStream;", "executor", "Ljava/util/concurrent/ExecutorService;", "path", "Ljava/nio/file/Path;", "loadBlocking", "loadBlockingOrNull", "ml-tools"})
@SourceDebugExtension(value={"SMAP\nModelPipelineLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelPipelineLoader.kt\ncom/jetbrains/ml/tools/model/pipeline/ModelPipelineLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,113:1\n1#2:114\n37#3,2:115\n*S KotlinDebug\n*F\n+ 1 ModelPipelineLoader.kt\ncom/jetbrains/ml/tools/model/pipeline/ModelPipelineLoader\n*L\n100#1:115,2\n*E\n"})
public final class ModelPipelineLoader {
    @NotNull
    public static final ModelPipelineLoader INSTANCE = new ModelPipelineLoader();

    private ModelPipelineLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CompletableFuture<ModelPipeline<MLModel<Object>, Object>> load(@NotNull Path path, @NotNull ExecutorService executor) {
        CompletableFuture<ModelPipeline<MLModel<Object>, Object>> completableFuture;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        try {
            CompletableFuture<ModelPipeline<MLModel<Object>, Object>> completableFuture2;
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
            completableFuture = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)((Object)completableFuture);
                boolean bl = false;
                completableFuture2 = INSTANCE.load(it, executor);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(completableFuture, (Throwable)throwable);
            }
            completableFuture = completableFuture2;
        }
        catch (ModelLoadingException ex) {
            CompletableFuture<ModelPipeline<MLModel<Object>, Object>> completableFuture3 = CompletableFuture.failedFuture(new ModelLoadingException("Could not load ML model from " + path, ex.getCause()));
            Intrinsics.checkNotNull(completableFuture3);
            completableFuture = completableFuture3;
        }
        catch (Throwable ex) {
            CompletableFuture completableFuture4 = CompletableFuture.failedFuture(new ModelLoadingException("Could not load ML model from " + path, ex));
            Intrinsics.checkNotNull(completableFuture4);
            completableFuture = completableFuture4;
        }
        return completableFuture;
    }

    @NotNull
    public final ModelPipeline<MLModel<Object>, Object> loadBlocking(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        ModelPipeline<MLModel<Object>, Object> modelPipeline = this.load(inputStream, (ExecutorService)new ThisThreadExecutorService()).join();
        Intrinsics.checkNotNullExpressionValue(modelPipeline, (String)"join(...)");
        return modelPipeline;
    }

    @Nullable
    public final ModelPipeline<MLModel<Object>, Object> loadBlockingOrNull(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return (ModelPipeline)((CompletableFuture)this.load(inputStream, (ExecutorService)new ThisThreadExecutorService()).handle((arg_0, arg_1) -> ModelPipelineLoader.loadBlockingOrNull$lambda$1(loadBlockingOrNull.1.INSTANCE, arg_0, arg_1))).join();
    }

    @NotNull
    public final ModelPipeline<MLModel<Object>, Object> loadBlocking(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ModelPipeline<MLModel<Object>, Object> modelPipeline = this.load(path, (ExecutorService)new ThisThreadExecutorService()).join();
        Intrinsics.checkNotNullExpressionValue(modelPipeline, (String)"join(...)");
        return modelPipeline;
    }

    @Nullable
    public final ModelPipeline<MLModel<Object>, Object> loadBlockingOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (ModelPipeline)((CompletableFuture)this.load(path, (ExecutorService)new ThisThreadExecutorService()).handle((arg_0, arg_1) -> ModelPipelineLoader.loadBlockingOrNull$lambda$2(loadBlockingOrNull.2.INSTANCE, arg_0, arg_1))).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CompletableFuture<ModelPipeline<MLModel<Object>, Object>> load(@NotNull InputStream inputStream, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        try {
            Closeable closeable = inputStream;
            int n = 8192;
            closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
            Throwable throwable = null;
            try {
                List list;
                CompletableFuture<? extends FeaturePreprocessor> completableFuture;
                ZipInputStream zip = (ZipInputStream)closeable;
                boolean bl = false;
                VFSNode.Directory root = VFSNode.Companion.fromZipInputStream(zip);
                JsonObject manifest = JsonElementKt.getJsonObject((JsonElement)root.getFile("manifest.json").getAsJson());
                String version2 = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)manifest), (Object)"version"))).getContent();
                if (!INSTANCE.isPipelineVersionSupported(version2)) {
                    boolean $i$a$-require-ModelPipelineLoader$load$2$22 = false;
                    String $i$a$-require-ModelPipelineLoader$load$2$22 = "ML dump version is not supported: " + version2;
                    throw new IllegalArgumentException($i$a$-require-ModelPipelineLoader$load$2$22.toString());
                }
                CompletableFuture<? extends MLModel<Object>> baseModel = Components.INSTANCE.loadModel(executor, root.getDirectory("base_model"));
                VFSNode.Directory directory = root.getDirectoryOrNull("preprocessing");
                if (directory != null) {
                    VFSNode.Directory it = directory;
                    boolean bl2 = false;
                    completableFuture = Components.INSTANCE.loadPreprocessor(executor, it);
                } else {
                    completableFuture = null;
                }
                CompletableFuture<? extends FeaturePreprocessor> preprocessing = completableFuture;
                CompletableFuture<? extends Map<String, Object>> info = Components.INSTANCE.loadInfo(executor, root.getDirectory("info"));
                List $this$load_u24lambda_u248_u24lambda_u246 = list = CollectionsKt.createListBuilder();
                boolean bl3 = false;
                $this$load_u24lambda_u248_u24lambda_u246.add(baseModel);
                $this$load_u24lambda_u248_u24lambda_u246.add(info);
                CompletableFuture<? extends FeaturePreprocessor> completableFuture2 = preprocessing;
                if (completableFuture2 != null) {
                    CompletableFuture<? extends FeaturePreprocessor> it = completableFuture2;
                    boolean bl4 = false;
                    $this$load_u24lambda_u248_u24lambda_u246.add(it);
                }
                List jobs = CollectionsKt.build((List)list);
                Collection $this$toTypedArray$iv = jobs;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
                CompletionStage completionStage = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).thenApply(arg_0 -> ModelPipelineLoader.load$lambda$8$lambda$7((Function1)new Function1<Void, ModelPipeline<MLModel<? extends Object>, Object>>(preprocessing, baseModel, info){
                    final /* synthetic */ CompletableFuture<? extends FeaturePreprocessor> $preprocessing;
                    final /* synthetic */ CompletableFuture<? extends MLModel<Object>> $baseModel;
                    final /* synthetic */ CompletableFuture<? extends Map<String, Object>> $info;
                    {
                        this.$preprocessing = $preprocessing;
                        this.$baseModel = $baseModel;
                        this.$info = $info;
                        super(1);
                    }

                    public final ModelPipeline<MLModel<Object>, Object> invoke(Void it) {
                        CompletableFuture<? extends FeaturePreprocessor> completableFuture = this.$preprocessing;
                        FeaturePreprocessor featurePreprocessor = completableFuture != null ? completableFuture.join() : null;
                        MLModel<Object> mLModel = this.$baseModel.join();
                        Intrinsics.checkNotNullExpressionValue(mLModel, (String)"join(...)");
                        Map<String, Object> map = this.$info.join();
                        Intrinsics.checkNotNullExpressionValue(map, (String)"join(...)");
                        return new ModelPipeline<MLModel<Object>, Object>(featurePreprocessor, mLModel, map);
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
                CompletionStage completionStage2 = completionStage;
                return completionStage2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable ex) {
            CompletableFuture<ModelPipeline<MLModel<Object>, Object>> completableFuture = CompletableFuture.failedFuture(new ModelLoadingException("Could not load ML model", ex));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
            return completableFuture;
        }
    }

    private final boolean isPipelineVersionSupported(String version2) {
        return Intrinsics.areEqual((Object)version2, (Object)"0");
    }

    private static final ModelPipeline loadBlockingOrNull$lambda$1(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModelPipeline)$tmp0.invoke(p0, (Object)p1);
    }

    private static final ModelPipeline loadBlockingOrNull$lambda$2(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModelPipeline)$tmp0.invoke(p0, (Object)p1);
    }

    private static final ModelPipeline load$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModelPipeline)$tmp0.invoke(p0);
    }
}

