/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.quickDoc;

import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiFile;
import com.jetbrains.rdclient.quickDoc.DocV2FakeElement;
import com.jetbrains.rdclient.quickDoc.FrontendDocumentationSessionWrapper;
import com.jetbrains.rdclient.ui.RichTextHtmlUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rdclient/quickDoc/FrontendDocumentationTarget;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "data", "Lcom/jetbrains/rdclient/quickDoc/FrontendDocumentationSessionWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/jetbrains/rdclient/quickDoc/FrontendDocumentationSessionWrapper;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;)V", "getData", "()Lcom/jetbrains/rdclient/quickDoc/FrontendDocumentationSessionWrapper;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/psi/PsiFile;", "navigatable", "Lcom/jetbrains/rdclient/quickDoc/DocV2FakeElement;", "getNavigatable", "()Lcom/jetbrains/rdclient/quickDoc/DocV2FakeElement;", "createPointer", "Lcom/intellij/model/Pointer;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult$Documentation;", "intellij.rd.client"})
public class FrontendDocumentationTarget
implements DocumentationTarget {
    @NotNull
    private final FrontendDocumentationSessionWrapper data;
    @NotNull
    private final Project project;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final DocV2FakeElement navigatable;

    public FrontendDocumentationTarget(@NotNull FrontendDocumentationSessionWrapper data, @NotNull Project project, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.data = data;
        this.project = project;
        this.file = file;
        this.navigatable = new DocV2FakeElement(this.file, this.data);
    }

    @NotNull
    public final FrontendDocumentationSessionWrapper getData() {
        return this.data;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public DocV2FakeElement getNavigatable() {
        return this.navigatable;
    }

    @NotNull
    public Pointer<FrontendDocumentationTarget> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
        return pointer;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        String string = this.data.getInitialInfo().getPresentableName();
        if (string == null) {
            string = "Documentation";
        }
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(string).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @NotNull
    public DocumentationResult.Documentation computeDocumentation() {
        return DocumentationResult.Companion.documentation(RichTextHtmlUtils.INSTANCE.highlightAttributedParts(this.data.getInitialInfo().getDescriptionHtml()));
    }
}

