/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkout;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.StatusBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;

public class CheckoutEventHandler
implements ProgressTracker {
    @Nullable
    private final ProgressIndicator myIndicator;
    private int myExternalsCount;
    @NotNull
    private final SvnVcs myVCS;
    private final boolean myIsExport;
    private int myCnt;

    public CheckoutEventHandler(@NotNull SvnVcs vcs, boolean isExport, @Nullable ProgressIndicator indicator) {
        if (vcs == null) {
            CheckoutEventHandler.$$$reportNull$$$0(0);
        }
        this.myIndicator = indicator;
        this.myVCS = vcs;
        this.myExternalsCount = 1;
        this.myIsExport = isExport;
        this.myCnt = 0;
    }

    public void consume(ProgressEvent event) {
        if (event.getPath() == null) {
            return;
        }
        if (event.getAction() == EventAction.UPDATE_EXTERNAL) {
            ++this.myExternalsCount;
            this.progress(SvnBundle.message("progress.text2.fetching.external.location", event.getFile().getAbsolutePath()));
        } else if (event.getAction() == EventAction.UPDATE_ADD) {
            this.progress2(this.myIsExport ? SvnBundle.message("progress.text2.exported", event.getFile().getName(), this.myCnt) : SvnBundle.message("progress.text2.checked.out", event.getFile().getName(), this.myCnt));
            ++this.myCnt;
        } else if (event.getAction() == EventAction.UPDATE_COMPLETED) {
            --this.myExternalsCount;
            this.progress2(this.myIsExport ? SvnBundle.message("progress.text2.exported.revision", event.getRevision()) : SvnBundle.message("progress.text2.checked.out.revision", event.getRevision()));
            if (this.myExternalsCount == 0 && event.getRevision() >= 0L) {
                this.myExternalsCount = 1;
                StatusBar.Info.set((String)(this.myIsExport ? SvnBundle.message("progress.text2.exported.revision", event.getRevision()) : SvnBundle.message("status.text.checked.out.revision", event.getRevision())), (Project)this.myVCS.getProject());
            }
        } else if (event.getAction() == EventAction.COMMIT_ADDED) {
            this.progress2(SvnBundle.message("progress.text2.adding", event.getPath()));
        } else if (event.getAction() == EventAction.COMMIT_DELTA_SENT) {
            this.progress2(SvnBundle.message("progress.text2.transmitting.delta", event.getPath()));
        }
    }

    @Override
    public void checkCancelled() throws ProcessCanceledException {
        if (this.myIndicator != null) {
            this.myIndicator.checkCanceled();
        }
    }

    private void progress(@NlsContexts.ProgressText @NotNull String text) {
        if (text == null) {
            CheckoutEventHandler.$$$reportNull$$$0(1);
        }
        if (this.myIndicator != null) {
            this.myIndicator.checkCanceled();
            this.myIndicator.setText(text);
            this.myIndicator.setText2("");
        } else {
            ProgressManager.progress((String)text);
        }
    }

    private void progress2(@NlsContexts.ProgressDetails @NotNull String text) {
        if (text == null) {
            CheckoutEventHandler.$$$reportNull$$$0(2);
        }
        if (this.myIndicator != null) {
            this.myIndicator.checkCanceled();
            this.myIndicator.setText2(text);
        } else {
            ProgressManager.progress2((String)text);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/checkout/CheckoutEventHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "progress";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "progress2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

