/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.facet.ProjectFacetManager;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumListEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.IKotlinFacetSettings;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.idea.statistics.KotlinASStatisticsEventFlags;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001fH\u0002R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getBuildSystemType", "", "it", "Lcom/intellij/openapi/module/Module;", "GROUP", "systemField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "platformField", "languageLevelField", "isMPPBuild", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "pluginInfoField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "eventFlags", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "nonDefaultLanguageFeaturesField", "Lcom/intellij/internal/statistic/eventLog/events/EnumListEventField;", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "composePlatformFields", "", "buildEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "Data", "kotlin.project-configuration"})
@SourceDebugExtension(value={"SMAP\nProjectConfigurationCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectConfigurationCollector.kt\norg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n369#2,4:126\n1869#3,2:130\n1563#3:132\n1634#3,3:133\n1563#3:136\n1634#3,3:137\n*S KotlinDebug\n*F\n+ 1 ProjectConfigurationCollector.kt\norg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector\n*L\n94#1:126,4\n49#1:130,2\n109#1:132\n109#1:133,3\n34#1:136\n34#1:137,3\n*E\n"})
public final class ProjectConfigurationCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("kotlin.project.configuration", 34, null, 4, null);
    @NotNull
    private final StringEventField systemField;
    @NotNull
    private final StringEventField platformField;
    @NotNull
    private final StringEventField languageLevelField;
    @NotNull
    private final BooleanEventField isMPPBuild;
    @NotNull
    private final PrimitiveEventField<PluginInfo> pluginInfoField;
    @NotNull
    private final LongEventField eventFlags;
    @NotNull
    private final EnumListEventField<LanguageFeature> nonDefaultLanguageFeaturesField;
    @NotNull
    private final VarargEventId buildEvent;

    /*
     * WARNING - void declaration
     */
    public ProjectConfigurationCollector() {
        void name$iv;
        Object object = new String[]{"JPS", "Maven", "Gradle", "unknown"};
        this.systemField = EventFields.String((String)"system", (List)CollectionsKt.listOf((Object[])object));
        this.platformField = EventFields.String((String)"platform", this.composePlatformFields());
        this.languageLevelField = EventFields.StringValidatedByRegexpReference$default((String)"languageLevel", (String)"version", null, (int)4, null);
        this.isMPPBuild = EventFields.Boolean((String)"isMPP");
        this.pluginInfoField = EventFields.PluginInfo;
        this.eventFlags = EventFields.Long$default((String)"eventFlags", null, (int)2, null);
        object = "nonDefaultLanguageFeatures";
        Function1 transform$iv = ProjectConfigurationCollector::nonDefaultLanguageFeaturesField$lambda$3;
        String description$iv = null;
        boolean $i$f$EnumList = false;
        this.nonDefaultLanguageFeaturesField = new EnumListEventField((String)name$iv, description$iv, LanguageFeature.class, transform$iv);
        object = new EventField[]{this.systemField, this.platformField, this.isMPPBuild, this.languageLevelField, this.pluginInfoField, this.eventFlags, this.nonDefaultLanguageFeaturesField};
        this.buildEvent = this.GROUP.registerVarargEvent("Build", (EventField[])object);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set metrics = new LinkedHashSet();
        List modulesLanguageDataInfo = (List)ActionsKt.runReadAction(() -> ProjectConfigurationCollector.getMetrics$lambda$1(project, this));
        Iterable $this$forEach$iv = modulesLanguageDataInfo;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Data it = (Data)element$iv;
            boolean bl = false;
            EventPair[] eventPairArray = new EventPair[]{this.systemField.with((Object)it.getBuildSystem()), this.platformField.with((Object)it.getPlatform()), this.languageLevelField.with((Object)it.getLanguageLevel()), this.isMPPBuild.with((Object)it.getMppBuild()), this.pluginInfoField.with((Object)KotlinIdePlugin.INSTANCE.getPluginInfo()), this.eventFlags.with((Object)KotlinASStatisticsEventFlags.INSTANCE.calculateAndPackEventsFlagsToLong(it.getKpmModule())), this.nonDefaultLanguageFeaturesField.with(it.getNonDefaultLanguageFeatures())};
            metrics.add(this.buildEvent.metric(eventPairArray));
        }
        return metrics;
    }

    private final String getBuildSystemType(Module it) {
        String string;
        BuildSystemType buildSystem = BuildSystemTypeKt.getBuildSystemType(it);
        if (buildSystem == BuildSystemType.JPS) {
            string = "JPS";
        } else {
            String string2 = buildSystem.toString();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"maven", (boolean)false, (int)2, null)) {
                string = "Maven";
            } else {
                string2 = buildSystem.toString();
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                String string4 = string2.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                string = StringsKt.contains$default((CharSequence)string4, (CharSequence)"gradle", (boolean)false, (int)2, null) ? "Gradle" : "unknown";
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> composePlatformFields() {
        Collection<CallSite> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray = new List[2];
        Object object = new String[]{"jvm", "jvm.android", "js", "wasm", "wasm.js", "wasm.wasi", "wasm.unknown", "common", "native.unknown", "unknown"};
        objectArray[0] = CollectionsKt.listOf((Object[])object);
        object = KonanTarget.Companion.getPredefinedTargets().keySet();
        int n = 1;
        Object[] objectArray2 = objectArray;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CallSite)((Object)("native." + (String)it)));
        }
        collection = (List)destination$iv$iv;
        objectArray2[n] = collection;
        return CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private static final List getMetrics$lambda$1(Project $project, ProjectConfigurationCollector this$0) {
        void $this$mapTo$iv$iv;
        List list2 = ProjectFacetManager.getInstance((Project)$project).getModulesWithFacet(KotlinFacetType.Companion.getTYPE_ID());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getModulesWithFacet(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Module module = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            Intrinsics.checkNotNull((Object)it);
            String buildSystem = this$0.getBuildSystemType((Module)it);
            String platform = ConfigureKotlinInProjectUtilsKt.getPlatform((Module)it);
            Object object = KotlinFacet.Companion.get((Module)it);
            IKotlinFacetSettings facetSettings = object != null && (object = (KotlinFacetConfiguration)object.getConfiguration()) != null ? object.getSettings() : null;
            IKotlinFacetSettings iKotlinFacetSettings = facetSettings;
            String languageLevel = iKotlinFacetSettings != null && (iKotlinFacetSettings = iKotlinFacetSettings.getLanguageLevel()) != null ? iKotlinFacetSettings.getVersionString() : null;
            List nonDefaultLanguageFeatures = CollectionsKt.toList((Iterable)ConfigureKotlinInProjectUtilsKt.getNonDefaultLanguageFeatures((Module)it));
            boolean mppBuild = KotlinFacetUtils.isMultiPlatformModule(facetSettings) || KotlinFacetUtils.isNewMultiPlatformModule(facetSettings);
            boolean kpmModule = KotlinFacetUtils.isKpmModule((Module)it);
            collection.add(new Data(buildSystem, platform, languageLevel, nonDefaultLanguageFeatures, mppBuild, kpmModule));
        }
        return (List)destination$iv$iv;
    }

    private static final String nonDefaultLanguageFeaturesField$lambda$3(LanguageFeature it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.name();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00c6\u0003JM\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector$Data;", "", "buildSystem", "", "platform", "languageLevel", "nonDefaultLanguageFeatures", "", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "mppBuild", "", "kpmModule", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;ZZ)V", "getBuildSystem", "()Ljava/lang/String;", "getPlatform", "getLanguageLevel", "getNonDefaultLanguageFeatures", "()Ljava/util/List;", "getMppBuild", "()Z", "getKpmModule", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "kotlin.project-configuration"})
    private static final class Data {
        @NotNull
        private final String buildSystem;
        @NotNull
        private final String platform;
        @Nullable
        private final String languageLevel;
        @NotNull
        private final List<LanguageFeature> nonDefaultLanguageFeatures;
        private final boolean mppBuild;
        private final boolean kpmModule;

        public Data(@NotNull String buildSystem, @NotNull String platform, @Nullable String languageLevel, @NotNull List<? extends LanguageFeature> nonDefaultLanguageFeatures, boolean mppBuild, boolean kpmModule) {
            Intrinsics.checkNotNullParameter((Object)buildSystem, (String)"buildSystem");
            Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
            Intrinsics.checkNotNullParameter(nonDefaultLanguageFeatures, (String)"nonDefaultLanguageFeatures");
            this.buildSystem = buildSystem;
            this.platform = platform;
            this.languageLevel = languageLevel;
            this.nonDefaultLanguageFeatures = nonDefaultLanguageFeatures;
            this.mppBuild = mppBuild;
            this.kpmModule = kpmModule;
        }

        @NotNull
        public final String getBuildSystem() {
            return this.buildSystem;
        }

        @NotNull
        public final String getPlatform() {
            return this.platform;
        }

        @Nullable
        public final String getLanguageLevel() {
            return this.languageLevel;
        }

        @NotNull
        public final List<LanguageFeature> getNonDefaultLanguageFeatures() {
            return this.nonDefaultLanguageFeatures;
        }

        public final boolean getMppBuild() {
            return this.mppBuild;
        }

        public final boolean getKpmModule() {
            return this.kpmModule;
        }

        @NotNull
        public final String component1() {
            return this.buildSystem;
        }

        @NotNull
        public final String component2() {
            return this.platform;
        }

        @Nullable
        public final String component3() {
            return this.languageLevel;
        }

        @NotNull
        public final List<LanguageFeature> component4() {
            return this.nonDefaultLanguageFeatures;
        }

        public final boolean component5() {
            return this.mppBuild;
        }

        public final boolean component6() {
            return this.kpmModule;
        }

        @NotNull
        public final Data copy(@NotNull String buildSystem, @NotNull String platform, @Nullable String languageLevel, @NotNull List<? extends LanguageFeature> nonDefaultLanguageFeatures, boolean mppBuild, boolean kpmModule) {
            Intrinsics.checkNotNullParameter((Object)buildSystem, (String)"buildSystem");
            Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
            Intrinsics.checkNotNullParameter(nonDefaultLanguageFeatures, (String)"nonDefaultLanguageFeatures");
            return new Data(buildSystem, platform, languageLevel, nonDefaultLanguageFeatures, mppBuild, kpmModule);
        }

        public static /* synthetic */ Data copy$default(Data data, String string, String string2, String string3, List list2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = data.buildSystem;
            }
            if ((n & 2) != 0) {
                string2 = data.platform;
            }
            if ((n & 4) != 0) {
                string3 = data.languageLevel;
            }
            if ((n & 8) != 0) {
                list2 = data.nonDefaultLanguageFeatures;
            }
            if ((n & 0x10) != 0) {
                bl = data.mppBuild;
            }
            if ((n & 0x20) != 0) {
                bl2 = data.kpmModule;
            }
            return data.copy(string, string2, string3, list2, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Data(buildSystem=" + this.buildSystem + ", platform=" + this.platform + ", languageLevel=" + this.languageLevel + ", nonDefaultLanguageFeatures=" + this.nonDefaultLanguageFeatures + ", mppBuild=" + this.mppBuild + ", kpmModule=" + this.kpmModule + ")";
        }

        public int hashCode() {
            int result2 = this.buildSystem.hashCode();
            result2 = result2 * 31 + this.platform.hashCode();
            result2 = result2 * 31 + (this.languageLevel == null ? 0 : this.languageLevel.hashCode());
            result2 = result2 * 31 + ((Object)this.nonDefaultLanguageFeatures).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.mppBuild);
            result2 = result2 * 31 + Boolean.hashCode(this.kpmModule);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            if (!Intrinsics.areEqual((Object)this.buildSystem, (Object)data.buildSystem)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.platform, (Object)data.platform)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.languageLevel, (Object)data.languageLevel)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.nonDefaultLanguageFeatures, data.nonDefaultLanguageFeatures)) {
                return false;
            }
            if (this.mppBuild != data.mppBuild) {
                return false;
            }
            return this.kpmModule == data.kpmModule;
        }
    }
}

