/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.ActivityId;
import com.intellij.history.core.ChangeListStorage;
import com.intellij.history.core.ChangeSetHolder;
import com.intellij.history.core.Content;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Clock;
import com.intellij.util.Consumer;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\fJ\b\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u0004\u0018\u00010\tJ!\u0010\u0016\u001a\u0004\u0018\u00010\t2\r\u0010\u0017\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\b\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ#\u0010\u001c\u001a\u0004\u0018\u00010\t2\r\u0010\u0017\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\b\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"J\u000e\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u000fJ\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u0007H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e8G\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006*"}, d2={"Lcom/intellij/history/core/ChangeList;", "", "storage", "Lcom/intellij/history/core/ChangeListStorage;", "<init>", "(Lcom/intellij/history/core/ChangeListStorage;)V", "changeSetDepth", "", "currentChangeSet", "Lcom/intellij/history/core/changes/ChangeSet;", "intervalBetweenActivities", "close", "", "force", "nextId", "", "addChange", "c", "Lcom/intellij/history/core/changes/Change;", "beginChangeSet", "doBeginChangeSet", "forceBeginChangeSet", "endChangeSet", "name", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "activityId", "Lcom/intellij/history/ActivityId;", "doEndChangeSet", "changesInTests", "", "getChangesInTests", "()Ljava/util/List;", "iterChanges", "", "accept", "v", "Lcom/intellij/history/core/changes/ChangeVisitor;", "purgeObsolete", "period", "setIntervalBetweenActivities", "value", "intellij.platform.lvcs.impl"})
@ApiStatus.Internal
public class ChangeList {
    @NotNull
    private final ChangeListStorage storage;
    private int changeSetDepth;
    @Nullable
    private ChangeSet currentChangeSet;
    private int intervalBetweenActivities;

    public ChangeList(@NotNull ChangeListStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
        this.intervalBetweenActivities = 43200000;
    }

    /*
     * Unable to fully structure code
     */
    public final synchronized void close() {
        block2: {
            if (ApplicationManager.getApplication().isUnitTestMode()) break block2;
            if (this.currentChangeSet == null) ** GOTO lbl-1000
            v0 = this.currentChangeSet;
            Intrinsics.checkNotNull((Object)v0);
            if (v0.isEmpty()) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            LocalHistoryLog.LOG.assertTrue(v1, (Object)("current changes won't be saved: " + this.currentChangeSet));
        }
        this.storage.close();
    }

    public final void force() {
        this.storage.force();
    }

    public final synchronized long nextId() {
        return this.storage.nextId();
    }

    public final synchronized void addChange(@NotNull Change c) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        boolean bl2 = bl = this.changeSetDepth != 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ChangeSet changeSet = this.currentChangeSet;
        Intrinsics.checkNotNull((Object)changeSet);
        changeSet.addChange(c);
    }

    public final synchronized void beginChangeSet() {
        int n = this.changeSetDepth;
        this.changeSetDepth = n + 1;
        if (this.changeSetDepth > 1) {
            return;
        }
        this.doBeginChangeSet();
    }

    private final void doBeginChangeSet() {
        this.currentChangeSet = new ChangeSet(this.nextId(), Clock.getTime());
    }

    @Nullable
    public final synchronized ChangeSet forceBeginChangeSet() {
        ChangeSet lastChangeSet = this.changeSetDepth > 0 ? this.doEndChangeSet(null, null) : null;
        int n = this.changeSetDepth;
        this.changeSetDepth = n + 1;
        this.doBeginChangeSet();
        return lastChangeSet;
    }

    @Nullable
    public final synchronized ChangeSet endChangeSet(@Nullable String name, @Nullable ActivityId activityId) {
        LocalHistoryLog.LOG.assertTrue(this.changeSetDepth > 0, (Object)"not balanced 'begin/end-change set' calls");
        int n = this.changeSetDepth;
        this.changeSetDepth = n + -1;
        if (this.changeSetDepth > 0) {
            return null;
        }
        return this.doEndChangeSet(name, activityId);
    }

    private final ChangeSet doEndChangeSet(String name, ActivityId activityId) {
        ChangeSet lastChangeSet;
        ChangeSet changeSet = this.currentChangeSet;
        Intrinsics.checkNotNull((Object)changeSet);
        if (changeSet.isEmpty()) {
            this.currentChangeSet = null;
            return null;
        }
        ChangeSet changeSet2 = lastChangeSet = this.currentChangeSet;
        Intrinsics.checkNotNull((Object)changeSet2);
        changeSet2.setName(name);
        lastChangeSet.setActivityId(activityId);
        lastChangeSet.lock();
        this.storage.writeNextSet(lastChangeSet);
        this.currentChangeSet = null;
        return lastChangeSet;
    }

    @TestOnly
    @NotNull
    public final List<ChangeSet> getChangesInTests() {
        return CollectionsKt.toList(this.iterChanges());
    }

    @NotNull
    public final synchronized Iterable<ChangeSet> iterChanges() {
        return new Iterable<ChangeSet>(this){
            final /* synthetic */ ChangeList this$0;
            {
                this.this$0 = changeList;
            }

            public Iterator<ChangeSet> iterator() {
                boolean bl = false;
                return new Iterator<ChangeSet>(this.this$0){
                    private final IntOpenHashSet recursionGuard;
                    private ChangeSetHolder currentBlock;
                    private ChangeSet next;
                    final /* synthetic */ ChangeList this$0;
                    {
                        this.this$0 = $receiver;
                        this.recursionGuard = new IntOpenHashSet(1000);
                        this.next = this.fetchNext();
                    }

                    public boolean hasNext() {
                        return this.next != null;
                    }

                    public ChangeSet next() {
                        ChangeSet changeSet = this.next;
                        Intrinsics.checkNotNull((Object)changeSet);
                        ChangeSet result = changeSet;
                        this.next = this.fetchNext();
                        return result;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private final ChangeSet fetchNext() {
                        if (this.currentBlock == null) {
                            ChangeList changeList = this.this$0;
                            ChangeList changeList2 = this.this$0;
                            ChangeList changeList3 = changeList;
                            synchronized (changeList3) {
                                boolean $i$a$-synchronized-ChangeList$iterChanges$1$1$fetchNext$32 = false;
                                this.currentBlock = ChangeList.access$getCurrentChangeSet$p(changeList2) != null ? new ChangeSetHolder(-1, ChangeList.access$getCurrentChangeSet$p(changeList2)) : ChangeList.access$getStorage$p(changeList2).readPrevious(-1, (IntSet)this.recursionGuard);
                                Unit $i$a$-synchronized-ChangeList$iterChanges$1$1$fetchNext$32 = Unit.INSTANCE;
                            }
                        }
                        ChangeList changeList = this.this$0;
                        ChangeList changeList4 = this.this$0;
                        ChangeList changeList5 = changeList;
                        synchronized (changeList5) {
                            boolean bl = false;
                            ChangeListStorage changeListStorage = ChangeList.access$getStorage$p(changeList4);
                            ChangeSetHolder changeSetHolder = this.currentBlock;
                            Intrinsics.checkNotNull((Object)changeSetHolder);
                            this.currentBlock = changeListStorage.readPrevious(changeSetHolder.id(), (IntSet)this.recursionGuard);
                            Unit unit = Unit.INSTANCE;
                        }
                        ChangeSetHolder changeSetHolder = this.currentBlock;
                        return changeSetHolder != null ? changeSetHolder.changeSet() : null;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    public final void accept(@NotNull ChangeVisitor v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        try {
            for (ChangeSet change : this.iterChanges()) {
                change.accept(v);
            }
        }
        catch (ChangeVisitor.StopVisitingException stopVisitingException) {
            // empty catch block
        }
        v.finished();
    }

    public final void purgeObsolete(long period) {
        this.storage.purge(period, this.intervalBetweenActivities, (Consumer<? super ChangeSet>)((Consumer)arg_0 -> ChangeList.purgeObsolete$lambda$2(ChangeList::purgeObsolete$lambda$1, arg_0)));
        this.storage.force();
    }

    @TestOnly
    public final void setIntervalBetweenActivities(int value) {
        this.intervalBetweenActivities = value;
    }

    private static final Unit purgeObsolete$lambda$1(ChangeSet changeSet) {
        for (Content each : changeSet.getContentsToPurge()) {
            each.release();
        }
        return Unit.INSTANCE;
    }

    private static final void purgeObsolete$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ChangeSet access$getCurrentChangeSet$p(ChangeList $this) {
        return $this.currentChangeSet;
    }

    public static final /* synthetic */ ChangeListStorage access$getStorage$p(ChangeList $this) {
        return $this.storage;
    }
}

