/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.changes.conflicts.MoveChangesDialog;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesCommitExecutor;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashSet;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ChangelistConflictResolution {
    SHELVE{

        @Override
        public boolean resolveConflict(Project project, Collection<? extends Change> changes, VirtualFile selected) {
            LocalChangeList changeList = ChangelistConflictResolution.getManager(project).getChangeList(changes.iterator().next());
            return CommitChangeListDialog.commitWithExecutor(project, changes, changeList, (CommitExecutor)new ShelveChangesCommitExecutor(project), null, null);
        }
    }
    ,
    MOVE{

        @Override
        public boolean resolveConflict(Project project, Collection<? extends Change> changes, VirtualFile selected) {
            ChangeListManager manager = ChangelistConflictResolution.getManager(project);
            HashSet<ChangeList> changeLists = new HashSet<ChangeList>();
            for (Change change : changes) {
                LocalChangeList list = manager.getChangeList(change);
                if (list == null) continue;
                changeLists.add((ChangeList)list);
            }
            if (changeLists.isEmpty()) {
                Messages.showInfoMessage((Project)project, (String)VcsBundle.message((String)"dialog.message.conflict.seems.to.be.resolved", (Object[])new Object[0]), (String)VcsBundle.message((String)"dialog.title.no.conflict.found", (Object[])new Object[0]));
                return true;
            }
            MoveChangesDialog dialog = new MoveChangesDialog(project, changes, changeLists, selected);
            if (dialog.showAndGet()) {
                manager.moveChangesTo(manager.getDefaultChangeList(), dialog.getIncludedChanges().toArray(Change.EMPTY_CHANGE_ARRAY));
                return true;
            }
            return false;
        }
    }
    ,
    SWITCH{

        @Override
        public boolean resolveConflict(Project project, Collection<? extends Change> changes, VirtualFile selected) {
            LocalChangeList changeList = ChangelistConflictResolution.getManager(project).getChangeList(changes.iterator().next());
            assert (changeList != null);
            ChangelistConflictResolution.getManager(project).setDefaultChangeList(changeList);
            return true;
        }
    }
    ,
    IGNORE{

        @Override
        public boolean resolveConflict(Project project, Collection<? extends Change> changes, VirtualFile selected) {
            ChangelistConflictTracker conflictTracker = ChangelistConflictTracker.getInstance(project);
            for (Change change : changes) {
                VirtualFile file = change.getVirtualFile();
                if (file == null) continue;
                conflictTracker.ignoreConflict(file, true);
            }
            return true;
        }
    };


    public abstract boolean resolveConflict(Project var1, Collection<? extends Change> var2, VirtualFile var3);

    private static ChangeListManager getManager(Project project) {
        return ChangeListManager.getInstance((Project)project);
    }
}

