/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public final class GroovyNegatedConditionalInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.negated.conditional.expression", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression grConditionalExpression) {
            if (grConditionalExpression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(grConditionalExpression);
            GrExpression condition = grConditionalExpression.getCondition();
            if (!BoolUtils.isNegation(condition)) {
                return;
            }
            this.registerError(grConditionalExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grConditionalExpression", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyNegatedConditionalInspection$Visitor", "visitConditionalExpression"));
        }
    }
}

