/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.rd.ide.model.BackendDaemonStateEnum;
import com.jetbrains.rd.ide.model.HeavyProcessTypeModel;
import com.jetbrains.rd.ide.model.RdDaemonModel;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.FrontendBundle;
import com.jetbrains.rdclient.daemon.FrontendTrafficLightRendererExtension;
import com.jetbrains.rdclient.daemon.FrontendTrafficLightRendererKt;
import com.jetbrains.rdclient.services.IdeBackend;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0014\u0010\u001a\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRenderer;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "model", "Lcom/jetbrains/rd/ide/model/RdDaemonModel;", "extensions", "", "Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRendererExtension;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lcom/jetbrains/rdclient/services/IdeBackend;Lcom/jetbrains/rd/ide/model/RdDaemonModel;[Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRendererExtension;)V", "[Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRendererExtension;", "fillDaemonCodeAnalyzerErrorsStatus", "", "status", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DaemonCodeAnalyzerStatus;", "severityRegistrar", "Lcom/intellij/codeInsight/daemon/impl/SeverityRegistrar;", "isValid", "", "isHidden", "()Z", "isLoaded", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendTrafficLightRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendTrafficLightRenderer.kt\ncom/jetbrains/rdclient/daemon/FrontendTrafficLightRenderer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n1310#2,2:126\n68#3,4:128\n14#3:132\n*S KotlinDebug\n*F\n+ 1 FrontendTrafficLightRenderer.kt\ncom/jetbrains/rdclient/daemon/FrontendTrafficLightRenderer\n*L\n39#1:126,2\n103#1:128,4\n30#1:132\n*E\n"})
public final class FrontendTrafficLightRenderer
extends TrafficLightRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PsiFile psiFile;
    @NotNull
    private final IdeBackend backend;
    @NotNull
    private final RdDaemonModel model;
    @NotNull
    private final FrontendTrafficLightRendererExtension[] extensions;
    @NotNull
    private static final Logger logger;

    public FrontendTrafficLightRenderer(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile psiFile, @NotNull IdeBackend backend, @NotNull RdDaemonModel model2, @NotNull FrontendTrafficLightRendererExtension[] extensions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
        super(project, editor);
        this.psiFile = psiFile;
        this.backend = backend;
        this.model = model2;
        this.extensions = extensions;
    }

    protected void fillDaemonCodeAnalyzerErrorsStatus(@NotNull TrafficLightRenderer.DaemonCodeAnalyzerStatus status, @NotNull SeverityRegistrar severityRegistrar) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)severityRegistrar, (String)"severityRegistrar");
        if (this.isHidden() && !this.isLoaded() || !InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)this.model.getState()))) {
            status.reasonWhySuspended = FrontendBundle.INSTANCE.message("loading.solution.components", new Object[0]);
            status.errorAnalyzingFinished = true;
        } else {
            FrontendTrafficLightRendererExtension extension;
            block18: {
                FrontendTrafficLightRendererExtension frontendTrafficLightRendererExtension;
                FrontendTrafficLightRendererExtension[] $this$firstOrNull$iv = this.extensions;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    FrontendTrafficLightRendererExtension element$iv;
                    FrontendTrafficLightRendererExtension it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!it.isAvailable()) continue;
                    frontendTrafficLightRendererExtension = element$iv;
                    break block18;
                }
                frontendTrafficLightRendererExtension = extension = null;
            }
            if (extension != null) {
                status.reasonWhySuspended = extension.getTooltip();
                status.errorAnalyzingFinished = true;
                return;
            }
            BackendDaemonStateEnum indicator = (BackendDaemonStateEnum)this.model.getState().getValueOrNull();
            if (status.errorAnalyzingFinished) {
                BackendDaemonStateEnum backendDaemonStateEnum = indicator;
                switch (backendDaemonStateEnum == null ? -1 : WhenMappings.$EnumSwitchMapping$0[backendDaemonStateEnum.ordinal()]) {
                    case -1: {
                        break;
                    }
                    case 1: {
                        if (status.reasonWhyDisabled == null) break;
                        status.reasonWhyDisabled = FrontendBundle.INSTANCE.message("analysis.is.not.supported.for.this.file", new Object[0]);
                        status.errorAnalyzingFinished = true;
                        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_INT_ARRAY, (String)"EMPTY_INT_ARRAY");
                        status.errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
                        break;
                    }
                    case 2: {
                        status.reasonWhyDisabled = FrontendBundle.INSTANCE.message("analysis.is.unsupported.for.document", new Object[0]);
                        status.errorAnalyzingFinished = true;
                        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_INT_ARRAY, (String)"EMPTY_INT_ARRAY");
                        status.errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
                        break;
                    }
                    case 3: {
                        Object message;
                        Object object = (String)this.model.getMessage().getValue();
                        if (object == null && (object = status.reasonWhyDisabled) == null) {
                            object = message = "";
                        }
                        if (!(((CharSequence)(message = ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)message))).toString())).length() == 0)) {
                            message = (String)message + (StringsKt.endsWith$default((String)message, (String)"", (boolean)false, (int)2, null) ? " " : " ");
                        }
                        status.reasonWhyDisabled = message;
                        status.errorAnalyzingFinished = true;
                        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_INT_ARRAY, (String)"EMPTY_INT_ARRAY");
                        status.errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
                        break;
                    }
                    case 4: {
                        String string = (String)this.model.getMessage().getValue();
                        if (string == null && (string = status.reasonWhySuspended) == null) {
                            string = "Code analysis suspended";
                        }
                        status.reasonWhySuspended = string;
                        status.errorAnalyzingFinished = true;
                        HeavyProcessTypeModel heavyProcessTypeModel = (HeavyProcessTypeModel)this.model.getHeavyProcessType().getValue();
                        Object object = status.heavyProcessType = heavyProcessTypeModel != null ? FrontendTrafficLightRendererKt.access$fromModel(heavyProcessTypeModel) : null;
                        if (status.heavyProcessType == null) break;
                        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_INT_ARRAY, (String)"EMPTY_INT_ARRAY");
                        status.errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
                        break;
                    }
                    case 5: 
                    case 6: {
                        status.errorAnalyzingFinished = false;
                        status.errorCounts = this.getErrorCounts();
                        break;
                    }
                    case 7: 
                    case 8: {
                        status.errorAnalyzingFinished = true;
                        status.errorCounts = this.getErrorCounts();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            PsiFile psiFile = this.psiFile;
            logger.trace("Backend daemon status for " + (psiFile != null && (psiFile = psiFile.getVirtualFile()) != null ? psiFile.getName() : null) + " is " + this.model.getState().getValueOrNull() + ", IDEA status is " + status);
        }
    }

    public boolean isValid() {
        if (!this.model.isBound()) {
            return false;
        }
        return super.isValid();
    }

    private final boolean isHidden() {
        return this.model.getState().getValueOrNull() == BackendDaemonStateEnum.HIDDEN;
    }

    private final boolean isLoaded() {
        return BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.backend.getSolution().isLoaded()));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendTrafficLightRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendTrafficLightRenderer.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRenderer$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BackendDaemonStateEnum.values().length];
            try {
                nArray[BackendDaemonStateEnum.HIDDEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.UNSUPPORTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.DISABLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.SUSPENDED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.INVALIDATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.IN_PROGRESS_LOCAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.IN_PROGRESS_GLOBAL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.UP_TO_DATE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

