/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.completion.cloud.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.ml.inline.completion.impl.configuration.MLCompletionConfigurableBase;
import com.intellij.ml.inline.completion.impl.thirdparty.MLCompletionThirdPartyConflictSupport;
import com.intellij.ml.llm.completion.cloud.CloudCompletionBundle;
import com.intellij.ml.llm.completion.cloud.kit.CloudCompletionKitSettings;
import com.intellij.ml.llm.completion.cloud.kit.CloudCompletionLanguageKit;
import com.intellij.ml.llm.completion.cloud.settings.CloudCompletionPolicy;
import com.intellij.ml.llm.completion.cloud.settings.CloudCompletionSettings;
import com.intellij.ml.llm.completion.impl.CloudCompletionAuthImpl;
import com.intellij.ml.llm.completion.impl.CloudCompletionSettingsImpl;
import com.intellij.ml.llm.completion.impl.CloudCompletionUtilsImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0012*\u00020\u0010H\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u0019*\u00020\u001bH\u0002J\u0012\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\u00020\u001bH\u0002J\f\u0010 \u001a\u00020\u001b*\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001d\u0010!\u001a\u00070\u000b\u00a2\u0006\u0002\b\"*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010#\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionConfigurable;", "Lcom/intellij/ml/inline/completion/impl/configuration/MLCompletionConfigurableBase;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "settings", "Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionSettings;", "getSettings", "()Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionSettings;", "getDisplayName", "", "getHelpTopic", "getId", "createSwitchableContent", "Lcom/intellij/ui/layout/ComponentPredicate;", "Lcom/intellij/ui/dsl/builder/Panel;", "displayLanguages", "", "langKitComparator", "Ljava/util/Comparator;", "Lcom/intellij/ml/llm/completion/cloud/kit/CloudCompletionLanguageKit;", "Lkotlin/Comparator;", "universalCompletionSettings", "baseEnableCompletionCheckBox", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBCheckBox;", "Lcom/intellij/ui/dsl/builder/Row;", "baseCompletionFrequencyMode", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionPolicy;", "baseCompletionIndicatorCheckBox", "activationSettings", "displayName", "Lorg/jetbrains/annotations/Nls;", "(Lcom/intellij/ml/llm/completion/cloud/settings/CloudCompletionPolicy;)Ljava/lang/String;", "intellij.ml.llm.completion"})
@SourceDebugExtension(value={"SMAP\nCloudCompletionConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudCompletionConfigurable.kt\ncom/intellij/ml/llm/completion/cloud/settings/CloudCompletionConfigurable\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n40#2,3:190\n774#3:193\n865#3,2:194\n774#3:196\n865#3,2:197\n774#3:199\n865#3,2:200\n1869#3,2:202\n*S KotlinDebug\n*F\n+ 1 CloudCompletionConfigurable.kt\ncom/intellij/ml/llm/completion/cloud/settings/CloudCompletionConfigurable\n*L\n26#1:190,3\n83#1:193\n83#1:194,2\n84#1:196\n84#1:197,2\n85#1:199\n85#1:200,2\n96#1:202,2\n*E\n"})
public final class CloudCompletionConfigurable
extends MLCompletionConfigurableBase {
    @NotNull
    private final CoroutineScope scope;

    public CloudCompletionConfigurable(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
    }

    private final CloudCompletionSettings getSettings() {
        boolean $i$f$service = false;
        Class<CloudCompletionSettings> serviceClass$iv = CloudCompletionSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (CloudCompletionSettings)object;
    }

    @NotNull
    public String getDisplayName() {
        Object[] objectArray = new Object[]{CloudCompletionUtilsImpl.INSTANCE.getPluginName()};
        return CloudCompletionBundle.message("cloud.completion.configurable.name", objectArray);
    }

    @NotNull
    public String getHelpTopic() {
        return "ai.completion.settings";
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }

    @Override
    @NotNull
    public ComponentPredicate createSwitchableContent(@NotNull Panel $this$createSwitchableContent) {
        ComponentPredicate componentPredicate;
        Intrinsics.checkNotNullParameter((Object)$this$createSwitchableContent, (String)"<this>");
        CloudCompletionSettingsImpl $this$createSwitchableContent_u24lambda_u240 = CloudCompletionSettingsImpl.INSTANCE;
        boolean bl = false;
        $this$createSwitchableContent_u24lambda_u240.listenToCompletionDisabled($this$createSwitchableContent);
        if (!MLCompletionThirdPartyConflictSupport.Companion.getInstance().conflictExists()) {
            ComponentPredicate componentPredicate2;
            ComponentPredicate componentPredicate3;
            ComponentPredicate componentPredicate4;
            ComponentPredicate componentPredicate5;
            ComponentPredicate authStatePredicate = CloudCompletionAuthImpl.INSTANCE.isAuthenticatedPredicate(this.scope);
            Ref.ObjectRef completionEnabled = new Ref.ObjectRef();
            Panel.row$default((Panel)$this$createSwitchableContent, null, arg_0 -> CloudCompletionConfigurable.createSwitchableContent$lambda$2(completionEnabled, this, arg_0), (int)1, null).visibleIf(authStatePredicate);
            RowsRange rowsRange = $this$createSwitchableContent.indent(arg_0 -> CloudCompletionConfigurable.createSwitchableContent$lambda$3(this, arg_0));
            if (completionEnabled.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"completionEnabled");
                componentPredicate5 = null;
            } else {
                componentPredicate5 = (ComponentPredicate)completionEnabled.element;
            }
            rowsRange.enabledIf(componentPredicate5).visibleIf(authStatePredicate);
            RowsRange rowsRange2 = $this$createSwitchableContent.indent(arg_0 -> CloudCompletionConfigurable.createSwitchableContent$lambda$6(this, arg_0));
            if (completionEnabled.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"completionEnabled");
                componentPredicate4 = null;
            } else {
                componentPredicate4 = (ComponentPredicate)completionEnabled.element;
            }
            rowsRange2.enabledIf(componentPredicate4).visibleIf(authStatePredicate);
            Row row = Panel.row$default((Panel)$this$createSwitchableContent, null, arg_0 -> CloudCompletionConfigurable.createSwitchableContent$lambda$7(this, arg_0), (int)1, null);
            if (completionEnabled.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"completionEnabled");
                componentPredicate3 = null;
            } else {
                componentPredicate3 = (ComponentPredicate)completionEnabled.element;
            }
            row.enabledIf(componentPredicate3).visibleIf(authStatePredicate);
            this.activationSettings($this$createSwitchableContent).visibleIf(ComponentPredicateKt.not((ComponentPredicate)authStatePredicate));
            if (completionEnabled.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"completionEnabled");
                componentPredicate2 = null;
            } else {
                componentPredicate2 = (ComponentPredicate)completionEnabled.element;
            }
            componentPredicate = ComponentPredicateKt.and((ComponentPredicate)componentPredicate2, (ComponentPredicate)authStatePredicate);
        } else {
            Panel.row$default((Panel)$this$createSwitchableContent, null, arg_0 -> CloudCompletionConfigurable.createSwitchableContent$lambda$8(this, arg_0), (int)1, null);
            componentPredicate = ComponentPredicate.Companion.getFALSE();
        }
        return componentPredicate;
    }

    private final void displayLanguages(Panel $this$displayLanguages) {
        CloudCompletionLanguageKit it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CloudCompletionLanguageKit.Companion.all();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CloudCompletionLanguageKit)element$iv$iv;
            boolean bl = false;
            if (!(!it.isExperimental())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CloudCompletionLanguageKit)element$iv$iv;
            boolean bl = false;
            if (!(!it.getHideInSettings())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String string;
            it = (CloudCompletionLanguageKit)element$iv$iv;
            boolean bl = false;
            try {
                string = it.getDisplayName();
            }
            catch (Throwable e) {
                string = null;
            }
            boolean bl2 = string != null;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), this.langKitComparator());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CloudCompletionLanguageKit kit = (CloudCompletionLanguageKit)element$iv;
            boolean bl = false;
            Panel.row$default((Panel)$this$displayLanguages, null, arg_0 -> CloudCompletionConfigurable.displayLanguages$lambda$13$lambda$12(kit, arg_0), (int)1, null);
        }
    }

    private final Comparator<CloudCompletionLanguageKit> langKitComparator() {
        List list = IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPrimaryIdeLanguages(...)");
        List primaryLangs = list;
        return new Comparator(primaryLangs){
            final /* synthetic */ List $primaryLangs$inlined;
            {
                this.$primaryLangs$inlined = list;
            }

            public final int compare(T a, T b) {
                CloudCompletionLanguageKit kit = (CloudCompletionLanguageKit)a;
                boolean bl = false;
                Integer n = this.$primaryLangs$inlined.indexOf(kit.getLanguageSettings().getLanguage());
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                Integer n2 = !(it == -1) ? n : null;
                kit = (CloudCompletionLanguageKit)b;
                Comparable comparable = n2 != null ? (Comparable)n2 : (Comparable)Integer.valueOf(Integer.MAX_VALUE);
                bl = false;
                n = this.$primaryLangs$inlined.indexOf(kit.getLanguageSettings().getLanguage());
                it = ((Number)n).intValue();
                bl2 = false;
                Integer n3 = !(it == -1) ? n : null;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(n3 != null ? (Comparable)n3 : (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
            }
        };
    }

    private final void universalCompletionSettings(Panel $this$universalCompletionSettings) {
        ComponentPredicate componentPredicate;
        Ref.ObjectRef universalCompletionSelected = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$universalCompletionSettings, null, arg_0 -> CloudCompletionConfigurable.universalCompletionSettings$lambda$16(universalCompletionSelected, arg_0), (int)1, null);
        RowsRange rowsRange = $this$universalCompletionSettings.indent(CloudCompletionConfigurable::universalCompletionSettings$lambda$21);
        if (universalCompletionSelected.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"universalCompletionSelected");
            componentPredicate = null;
        } else {
            componentPredicate = (ComponentPredicate)universalCompletionSelected.element;
        }
        rowsRange.visibleIf(componentPredicate);
    }

    private final Cell<JBCheckBox> baseEnableCompletionCheckBox(Row $this$baseEnableCompletionCheckBox) {
        Cell checkBox = $this$baseEnableCompletionCheckBox.checkBox(CloudCompletionBundle.message("settings.checkbox.enable.inline.completion.feature", new Object[0])).gap(RightGap.SMALL);
        $this$baseEnableCompletionCheckBox.icon(CloudCompletionUtilsImpl.INSTANCE.getPluginLogo16Colored());
        return checkBox;
    }

    private final Cell<ComboBox<CloudCompletionPolicy>> baseCompletionFrequencyMode(Row $this$baseCompletionFrequencyMode) {
        Cell comboBox = $this$baseCompletionFrequencyMode.comboBox((Collection)CloudCompletionPolicy.getEntries(), BuilderKt.textListCellRenderer(arg_0 -> CloudCompletionConfigurable.baseCompletionFrequencyMode$lambda$22(this, arg_0))).gap(RightGap.SMALL);
        $this$baseCompletionFrequencyMode.icon(CloudCompletionUtilsImpl.INSTANCE.getPluginLogo16Colored());
        return comboBox;
    }

    private final Cell<JBCheckBox> baseCompletionIndicatorCheckBox(Row $this$baseCompletionIndicatorCheckBox) {
        Cell checkBox = Cell.comment$default((Cell)$this$baseCompletionIndicatorCheckBox.checkBox(CloudCompletionBundle.message("settings.checkbox.enable.completion.indicator.feature", new Object[0])).gap(RightGap.SMALL), (String)CloudCompletionBundle.message("settings.checkbox.enable.completion.indicator.description", new Object[0]), (int)0, null, (int)6, null);
        $this$baseCompletionIndicatorCheckBox.icon(CloudCompletionUtilsImpl.INSTANCE.getPluginLogo16Colored()).gap(RightGap.SMALL);
        Icon icon = AllIcons.General.Beta;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Beta");
        $this$baseCompletionIndicatorCheckBox.icon(icon);
        return checkBox;
    }

    private final Row activationSettings(Panel $this$activationSettings) {
        return Panel.row$default((Panel)$this$activationSettings, null, arg_0 -> CloudCompletionConfigurable.activationSettings$lambda$28(this, arg_0), (int)1, null);
    }

    private final String getDisplayName(CloudCompletionPolicy $this$displayName) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$displayName.ordinal()]) {
            case 1 -> CloudCompletionBundle.message("cloud.completion.policy.creative.name", new Object[0]);
            case 2 -> CloudCompletionBundle.message("cloud.completion.policy.balanced.name", new Object[0]);
            case 3 -> CloudCompletionBundle.message("cloud.completion.policy.focused.name", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final void createSwitchableContent$lambda$2$lambda$1(HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CloudCompletionSettingsImpl.INSTANCE.navigateToLLMConfigurable();
    }

    private static final Unit createSwitchableContent$lambda$2(Ref.ObjectRef $completionEnabled, CloudCompletionConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{CloudCompletionUtilsImpl.INSTANCE.getPluginName()};
        $completionEnabled.element = ButtonKt.getSelected((Cell)Cell.comment$default((Cell)ButtonKt.bindSelected(this$0.baseEnableCompletionCheckBox($this$row), (ObservableMutableProperty)((ObservableMutableProperty)this$0.getSettings().isEnabled())), (String)CloudCompletionBundle.message("cloud.completion.enabled.comment", objectArray), (int)0, CloudCompletionConfigurable::createSwitchableContent$lambda$2$lambda$1, (int)2, null));
        return Unit.INSTANCE;
    }

    private static final Unit createSwitchableContent$lambda$3(CloudCompletionConfigurable this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        this$0.displayLanguages($this$indent);
        this$0.universalCompletionSettings($this$indent);
        return Unit.INSTANCE;
    }

    private static final Unit createSwitchableContent$lambda$6$lambda$4(CloudCompletionConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(CloudCompletionBundle.message("cloud.completion.policy.label", new Object[0]));
        ComboBoxKt.bindItem(this$0.baseCompletionFrequencyMode($this$row), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(CloudCompletionSettings.Companion.getInstance().getState()){

            public Object get() {
                return ((CloudCompletionSettings.State)this.receiver).getPolicy();
            }

            public void set(Object value) {
                ((CloudCompletionSettings.State)this.receiver).setPolicy((CloudCompletionPolicy)((Object)value));
            }
        })));
        return Unit.INSTANCE;
    }

    private static final Unit createSwitchableContent$lambda$6$lambda$5(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comment$default((Row)$this$row, (String)CloudCompletionBundle.message("cloud.completion.policy.comment", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createSwitchableContent$lambda$6(CloudCompletionConfigurable this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> CloudCompletionConfigurable.createSwitchableContent$lambda$6$lambda$4(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$indent, null, CloudCompletionConfigurable::createSwitchableContent$lambda$6$lambda$5, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createSwitchableContent$lambda$7(CloudCompletionConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected(this$0.baseCompletionIndicatorCheckBox($this$row), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.getSettings().getState()){

            public Object get() {
                return ((CloudCompletionSettings.State)this.receiver).getCompletionIndicator();
            }

            public void set(Object value) {
                ((CloudCompletionSettings.State)this.receiver).setCompletionIndicator((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createSwitchableContent$lambda$8(CloudCompletionConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.selected(this$0.baseEnableCompletionCheckBox($this$row), (boolean)false).enabled(false);
        return Unit.INSTANCE;
    }

    private static final Unit displayLanguages$lambda$13$lambda$12(CloudCompletionLanguageKit $kit, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox($kit.getDisplayName()), (Function0)((Function0)new Function0<Boolean>((Object)$kit.getLanguageSettings()){

            public final Boolean invoke() {
                return ((CloudCompletionKitSettings)this.receiver).isEnabled();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$kit.getLanguageSettings()){

            public final void invoke(boolean p0) {
                ((CloudCompletionKitSettings)this.receiver).toggle$intellij_ml_llm_completion(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit universalCompletionSettings$lambda$16(Ref.ObjectRef $universalCompletionSelected, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $universalCompletionSelected.element = ButtonKt.getSelected((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(CloudCompletionBundle.message("cloud.completion.universal.completion.checkbox", new Object[0])), (Function0)((Function0)new Function0<Boolean>((Object)CloudCompletionSettingsImpl.INSTANCE){

            public final Boolean invoke() {
                return ((CloudCompletionSettingsImpl)this.receiver).isUniversalCompletionEnabled();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)CloudCompletionSettingsImpl.INSTANCE){

            public final void invoke(boolean p0) {
                ((CloudCompletionSettingsImpl)this.receiver).setUniversalCompletionEnabled(p0);
            }
        })).gap(RightGap.SMALL));
        Icon icon = AllIcons.General.Beta;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Beta");
        $this$row.icon(icon);
        Row.comment$default((Row)$this$row, (String)CloudCompletionBundle.message("cloud.completion.universal.completion.comment", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final String universalCompletionSettings$lambda$21$lambda$20$lambda$17() {
        String string = CloudCompletionSettingsImpl.INSTANCE.getIgnoredCompletionExtensions();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final Unit universalCompletionSettings$lambda$21$lambda$20$lambda$18(String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CloudCompletionSettingsImpl.INSTANCE.setIgnoredCompletionExtensions(value);
        return Unit.INSTANCE;
    }

    private static final Unit universalCompletionSettings$lambda$21$lambda$20$lambda$19(JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getEmptyText().setText(CloudCompletionBundle.message("cloud.completion.universal.completion.exclude.files.example.text", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit universalCompletionSettings$lambda$21$lambda$20(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(CloudCompletionBundle.message("cloud.completion.universal.completion.exclude.files.label", new Object[0]));
        Cell.comment$default((Cell)TextFieldKt.bindText((Cell)$this$row.textField(), CloudCompletionConfigurable::universalCompletionSettings$lambda$21$lambda$20$lambda$17, CloudCompletionConfigurable::universalCompletionSettings$lambda$21$lambda$20$lambda$18), (String)CloudCompletionBundle.message("cloud.completion.universal.completion.exclude.files.comment", new Object[0]), (int)0, null, (int)6, null).applyToComponent(CloudCompletionConfigurable::universalCompletionSettings$lambda$21$lambda$20$lambda$19).gap(RightGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit universalCompletionSettings$lambda$21(Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, CloudCompletionConfigurable::universalCompletionSettings$lambda$21$lambda$20, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final String baseCompletionFrequencyMode$lambda$22(CloudCompletionConfigurable this$0, CloudCompletionPolicy it) {
        CloudCompletionPolicy cloudCompletionPolicy = it;
        return cloudCompletionPolicy != null ? this$0.getDisplayName(cloudCompletionPolicy) : null;
    }

    private static final Unit activationSettings$lambda$28$lambda$27$lambda$23(CloudCompletionConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.selected(this$0.baseEnableCompletionCheckBox($this$row), (boolean)false).enabled(false);
        return Unit.INSTANCE;
    }

    private static final Unit activationSettings$lambda$28$lambda$27$lambda$26$lambda$25(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        CloudCompletionSettingsImpl $this$activationSettings_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425_u24lambda_u2424 = CloudCompletionSettingsImpl.INSTANCE;
        boolean bl = false;
        $this$activationSettings_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425_u24lambda_u2424.activationButton($this$row);
        return Unit.INSTANCE;
    }

    private static final Unit activationSettings$lambda$28$lambda$27$lambda$26(Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, CloudCompletionConfigurable::activationSettings$lambda$28$lambda$27$lambda$26$lambda$25, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit activationSettings$lambda$28$lambda$27(CloudCompletionConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CloudCompletionConfigurable.activationSettings$lambda$28$lambda$27$lambda$23(this$0, arg_0), (int)1, null);
        $this$panel.indent(CloudCompletionConfigurable::activationSettings$lambda$28$lambda$27$lambda$26);
        return Unit.INSTANCE;
    }

    private static final Unit activationSettings$lambda$28(CloudCompletionConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(arg_0 -> CloudCompletionConfigurable.activationSettings$lambda$28$lambda$27(this$0, arg_0));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CloudCompletionPolicy.values().length];
            try {
                nArray[CloudCompletionPolicy.Creative.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudCompletionPolicy.Balanced.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudCompletionPolicy.Focused.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

