/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr.jmc;

import com.intellij.profiler.ultimate.jfr.jmc.EventCountInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;

public final class EventTypeFolderNode {
    private final String name;
    private final List<Object> children = new ArrayList<Object>();

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventTypeFolderNode) {
            return Objects.equals(this.name, ((EventTypeFolderNode)obj).name);
        }
        return false;
    }

    private EventTypeFolderNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.name;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<?> getChildren() {
        return this.children;
    }

    public String toString() {
        return "EventTypeFolderNode: " + this.getName();
    }

    public IQuantity getCount() {
        return UnitLookup.NUMBER_UNITY.quantity(this.performCount());
    }

    private long performCount() {
        long childCount = 0L;
        for (Object c : this.children) {
            if (c instanceof EventTypeFolderNode) {
                childCount += ((EventTypeFolderNode)c).performCount();
                continue;
            }
            if (!(c instanceof EventTypeNode)) continue;
            childCount += ((EventTypeNode)c).eventCountInfo.getRealCount();
        }
        return childCount;
    }

    private void sortChildren() {
        for (Object c : this.getChildren()) {
            if (!(c instanceof EventTypeFolderNode)) continue;
            ((EventTypeFolderNode)c).sortChildren();
        }
        this.getChildren().sort((o1, o2) -> {
            if (o1 instanceof EventTypeFolderNode && o2 instanceof EventTypeFolderNode) {
                return ((EventTypeFolderNode)o1).getName().compareTo(((EventTypeFolderNode)o2).getName());
            }
            if (o1 instanceof EventTypeNode && o2 instanceof EventTypeNode) {
                return ((EventTypeNode)o1).type.getName().compareTo(((EventTypeNode)o2).type.getName());
            }
            return o1 instanceof EventTypeFolderNode ? -1 : 1;
        });
    }

    private EventTypeFolderNode getOrCreateFolder(String label2) {
        for (Object c : this.children) {
            if (!(c instanceof EventTypeFolderNode) || !((EventTypeFolderNode)c).getName().equals(label2)) continue;
            return (EventTypeFolderNode)c;
        }
        EventTypeFolderNode folder = new EventTypeFolderNode(label2);
        this.children.add(folder);
        return folder;
    }

    static EventTypeFolderNode buildRoot(Stream<TypeWithCategory> allEventTypes) {
        EventTypeFolderNode eventTypesRoot = new EventTypeFolderNode("Events by type");
        allEventTypes.forEach(e -> EventTypeFolderNode.addEventType(eventTypesRoot, e.getType(), e.getCategory(), e.getEventCountInfo()));
        eventTypesRoot.sortChildren();
        return eventTypesRoot;
    }

    private static void addEventType(EventTypeFolderNode parentNode, IType<IItem> t, String[] category, EventCountInfo eventCountInfo) {
        if (category != null && category.length > 0) {
            for (String part : category) {
                parentNode = parentNode.getOrCreateFolder(part.trim());
            }
        } else {
            parentNode = parentNode.getOrCreateFolder("Uncategorized");
        }
        parentNode.children.add(new EventTypeNode(t, eventCountInfo));
    }

    public static class EventTypeNode {
        private final IType<IItem> type;
        private final EventCountInfo eventCountInfo;

        EventTypeNode(IType<IItem> type, EventCountInfo eventCountInfo) {
            this.type = type;
            this.eventCountInfo = eventCountInfo;
        }

        public String toString() {
            return "EventTypeNode: " + this.type.getName() + "(" + this.type.getIdentifier() + ")";
        }

        public IType<IItem> getType() {
            return this.type;
        }

        public IQuantity getCount() {
            return UnitLookup.NUMBER_UNITY.quantity(this.eventCountInfo.getRealCount());
        }

        public EventCountInfo getEventCountInfo() {
            return this.eventCountInfo;
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }

        public boolean equals(Object obj) {
            if (obj instanceof EventTypeNode) {
                return Objects.equals(this.type, ((EventTypeNode)obj).type);
            }
            return false;
        }
    }

    static class TypeWithCategory {
        private final String[] category;
        private final IType<IItem> type;
        private final EventCountInfo eventCountInfo;

        TypeWithCategory(IType<IItem> type, String[] category, EventCountInfo eventCountInfo) {
            this.category = category;
            this.type = type;
            this.eventCountInfo = eventCountInfo;
        }

        IType<IItem> getType() {
            return this.type;
        }

        String[] getCategory() {
            return this.category;
        }

        EventCountInfo getEventCountInfo() {
            return this.eventCountInfo;
        }
    }
}

