/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sourceToSink;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewToolWindowUtils;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.sourceToSink.DeepTaintAnalyzerException;
import com.intellij.codeInspection.sourceToSink.MarkAsSafeFix;
import com.intellij.codeInspection.sourceToSink.PropagateAnnotationPanel;
import com.intellij.codeInspection.sourceToSink.TaintAnalyzer;
import com.intellij.codeInspection.sourceToSink.TaintNode;
import com.intellij.codeInspection.sourceToSink.TaintValue;
import com.intellij.codeInspection.sourceToSink.TaintValueFactory;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

public class PropagateFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final TaintValueFactory myTaintValueFactory;
    private final boolean supportRefactoring;

    public PropagateFix(@NotNull PsiElement sourcePsi, @NotNull TaintValueFactory taintValueFactory, boolean supportRefactoring) {
        if (sourcePsi == null) {
            PropagateFix.$$$reportNull$$$0(0);
        }
        if (taintValueFactory == null) {
            PropagateFix.$$$reportNull$$$0(1);
        }
        super(sourcePsi);
        this.myTaintValueFactory = taintValueFactory;
        this.supportRefactoring = supportRefactoring;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            PropagateFix.$$$reportNull$$$0(2);
        }
        if (previewDescriptor == null) {
            PropagateFix.$$$reportNull$$$0(3);
        }
        String message = JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.preview.propagate", new Object[0]);
        return new IntentionPreviewInfo.Html(message);
    }

    @NotNull
    public String getText() {
        String string = JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.propagate.safe.text", new Object[0]);
        if (string == null) {
            PropagateFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean availableInBatchMode() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        List roots;
        if (project == null) {
            PropagateFix.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            PropagateFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            PropagateFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            PropagateFix.$$$reportNull$$$0(8);
        }
        if ((roots = (List)ActionUtil.underModalProgress((Project)project, (String)CodeInsightBundle.message((String)"progress.title.preparing.result", (Object[])new Object[0]), () -> {
            UExpression uExpression = (UExpression)UastContextKt.toUElementOfExpectedTypes((PsiElement)startElement, (Class[])new Class[]{UExpression.class});
            if (uExpression == null) {
                return null;
            }
            PsiElement reportedElement = uExpression.getSourcePsi();
            if (reportedElement == null) {
                return null;
            }
            TaintAnalyzer analyzer = new TaintAnalyzer(this.myTaintValueFactory);
            try {
                TaintValue value = analyzer.analyzeExpression(uExpression, false, TaintValue.TAINTED);
                if (value != TaintValue.UNKNOWN) {
                    return null;
                }
            }
            catch (DeepTaintAnalyzerException e) {
                return null;
            }
            return ContainerUtil.map(analyzer.getNonMarkedElements(), nonMarkedElement -> new TaintNode(null, (PsiElement)nonMarkedElement.myNonMarked, nonMarkedElement.myRef, this.myTaintValueFactory, nonMarkedElement.myNext));
        })) == null || roots.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (TaintNode root : roots) {
                Set<TaintNode> toAnnotate2 = new HashSet<TaintNode>();
                if ((toAnnotate2 = PropagateAnnotationPanel.getSelectedElements(root, toAnnotate2)) == null || root.myTaintValue == TaintValue.TAINTED) continue;
                this.annotate(project, toAnnotate2);
            }
            return;
        }
        Consumer<Collection> callback = toAnnotate -> {
            this.annotate(project, (Collection<TaintNode>)toAnnotate);
            ToolWindow toolWindow = ProblemsViewToolWindowUtils.INSTANCE.getToolWindow(project);
            if (toolWindow != null) {
                toolWindow.hide();
            }
        };
        PropagateAnnotationPanel panel = new PropagateAnnotationPanel(project, roots, callback, this.supportRefactoring);
        String title = JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.propagate.safe.toolwindow.title", new Object[0]);
        ToolWindow toolWindow = ProblemsViewToolWindowUtils.INSTANCE.getToolWindow(project);
        if (toolWindow == null) {
            return;
        }
        Content content = ContentFactory.getInstance().createContent((JComponent)panel, title, true);
        panel.setContent(content);
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContent(content);
        contentManager.setSelectedContent(content);
        toolWindow.activate(null);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            PropagateFix.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            PropagateFix.$$$reportNull$$$0(10);
        }
        if (psiFile == null) {
            PropagateFix.$$$reportNull$$$0(11);
        }
        return new IntentionPreviewInfo.Html(JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.propagate.safe.preview", new Object[0]));
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.propagate.safe.family", new Object[0]);
        if (string == null) {
            PropagateFix.$$$reportNull$$$0(12);
        }
        return string;
    }

    private void annotate(@NotNull Project project, @NotNull Collection<TaintNode> toAnnotate) {
        List nonMarkedNodes;
        Set<PsiElement> psiElements;
        if (project == null) {
            PropagateFix.$$$reportNull$$$0(13);
        }
        if (toAnnotate == null) {
            PropagateFix.$$$reportNull$$$0(14);
        }
        if ((psiElements = PropagateFix.getPsiElements(nonMarkedNodes = ContainerUtil.filter(toAnnotate, this::isNonMarked))) == null) {
            return;
        }
        MarkAsSafeFix.markAsSafe(project, psiElements, this.myTaintValueFactory);
    }

    private boolean isNonMarked(@NotNull TaintNode taintNode) {
        if (taintNode == null) {
            PropagateFix.$$$reportNull$$$0(15);
        }
        if (taintNode.myTaintValue == TaintValue.TAINTED) {
            return false;
        }
        PsiElement psiElement = taintNode.getPsiElement();
        if (psiElement == null) {
            return true;
        }
        return this.myTaintValueFactory.fromElement(psiElement, null) != TaintValue.UNTAINTED;
    }

    private static @Nullable Set<@NotNull PsiElement> getPsiElements(@NotNull Collection<TaintNode> toAnnotate) {
        if (toAnnotate == null) {
            PropagateFix.$$$reportNull$$$0(16);
        }
        HashSet<PsiElement> psiElements = new HashSet<PsiElement>();
        for (TaintNode node : toAnnotate) {
            PsiElement psiElement = node.getPsiElement();
            if (psiElement == null) {
                return null;
            }
            if (psiElement instanceof PsiLocalVariable) continue;
            psiElements.add(psiElement);
        }
        return psiElements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePsi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taintValueFactory";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/sourceToSink/PropagateFix";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAnnotate";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taintNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/sourceToSink/PropagateFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 4: 
            case 12: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isNonMarked";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 12 -> new IllegalStateException(string);
        };
    }
}

