/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.gcommon.collect.Ordering;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.data.Dummies;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J*\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0017H\u0007J\u0016\u0010\u0019\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0017J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0017J\u0016\u0010\u001c\u001a\u00020\u00042\u000e\u0010\u001d\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001eJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0004J\u0016\u0010!\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0017J\u0016\u0010\"\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0017J\u001c\u0010#\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170%J\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0(J\u001e\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u001e2\u0006\u0010 \u001a\u00020\u0004J\u0012\u0010*\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\n0\u001e2\u0006\u0010 \u001a\u00020\u0004\u00a8\u0006+"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/data/DataFrameUtil;", "", "()V", "appendReplace", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "df0", "df1", "applyTransform", "data", "variable", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "transformVar", "concat", "dataframes", "", "outer", "", "createVariable", "name", "", "label", "findVariableOrFail", "varName", "findVariableOrNull", "fromMap", "map", "", "getSummaryText", "df", "hasVariable", "isNumeric", "removeAllExcept", "keepNames", "", "sortedCopy", "variables", "", "toMap", "transformVarFor", "plot-base"})
@SourceDebugExtension(value={"SMAP\nDataFrameUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrameUtil.kt\norg/jetbrains/letsPlot/core/plot/base/data/DataFrameUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1194#2,2:180\n1222#2,4:182\n766#2:186\n857#2,2:187\n766#2:189\n857#2,2:190\n766#2:192\n857#2,2:193\n1549#2:196\n1620#2,3:197\n2661#2,7:200\n1855#2:207\n1549#2:208\n1620#2,3:209\n1856#2:212\n1855#2,2:213\n1#3:195\n*S KotlinDebug\n*F\n+ 1 DataFrameUtil.kt\norg/jetbrains/letsPlot/core/plot/base/data/DataFrameUtil\n*L\n79#1:180,2\n79#1:182,4\n94#1:186\n94#1:187,2\n95#1:189\n95#1:190,2\n96#1:192\n96#1:193,2\n157#1:196\n157#1:197,3\n158#1:200,7\n166#1:207\n167#1:208\n167#1:209,3\n166#1:212\n84#1:213,2\n*E\n"})
public final class DataFrameUtil {
    @NotNull
    public static final DataFrameUtil INSTANCE = new DataFrameUtil();

    private DataFrameUtil() {
    }

    @NotNull
    public final DataFrame.Variable transformVarFor(@NotNull Aes<?> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        return TransformVar.INSTANCE.forAes(aes2);
    }

    @NotNull
    public final DataFrame applyTransform(@NotNull DataFrame data2, @NotNull DataFrame.Variable variable, @NotNull Aes<?> aes2, @NotNull Transform transform2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        DataFrame.Variable transformVar = this.transformVarFor(aes2);
        return this.applyTransform(data2, variable, transformVar, transform2);
    }

    @NotNull
    public final DataFrame applyTransform(@NotNull DataFrame data2, @NotNull DataFrame.Variable variable, @NotNull DataFrame.Variable transformVar, @NotNull Transform transform2) {
        List<Double> list2;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)transformVar, (String)"transformVar");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        try {
            list2 = ScaleUtil.INSTANCE.applyTransform(data2.get(variable), transform2);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Can't transform '" + variable.getName() + "' with " + Reflection.getOrCreateKotlinClass(transform2.getClass()).getSimpleName() + " : " + e.getMessage());
        }
        List<Double> transformed = list2;
        return data2.builder().putNumeric(transformVar, transformed).build();
    }

    public final boolean hasVariable(@NotNull DataFrame data2, @NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        for (DataFrame.Variable v : data2.variables()) {
            if (!Intrinsics.areEqual((Object)varName, (Object)v.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final DataFrame.Variable findVariableOrFail(@NotNull DataFrame data2, @NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        for (DataFrame.Variable variable : data2.variables()) {
            if (!Intrinsics.areEqual((Object)varName, (Object)variable.getName())) continue;
            return variable;
        }
        throw new IllegalArgumentException(data2.undefinedVariableErrorMessage(varName));
    }

    @Nullable
    public final DataFrame.Variable findVariableOrNull(@NotNull DataFrame data2, @NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        if (!this.hasVariable(data2, varName)) {
            return null;
        }
        return this.findVariableOrFail(data2, varName);
    }

    public final boolean isNumeric(@NotNull DataFrame data2, @NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        return data2.isNumeric(this.findVariableOrFail(data2, varName));
    }

    @NotNull
    public final List<DataFrame.Variable> sortedCopy(@NotNull Iterable<DataFrame.Variable> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Ordering ordering = Ordering.Companion.from(DataFrameUtil::sortedCopy$lambda$0);
        return ordering.sortedCopy(variables);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, DataFrame.Variable> variables(@NotNull DataFrame df) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        Iterable $this$associateBy$iv = df.variables();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            DataFrame.Variable variable = (DataFrame.Variable)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(p0.getName(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final DataFrame appendReplace(@NotNull DataFrame df0, @NotNull DataFrame df1) {
        DataFrame.Variable it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)df0, (String)"df0");
        Intrinsics.checkNotNullParameter((Object)df1, (String)"df1");
        Iterable iterable = df0.variables();
        DataFrame.Builder builder = new DataFrame.Builder();
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DataFrame.Variable)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !INSTANCE.variables(df1).containsKey(it.getName());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = df0.variables();
        builder = DataFrameUtil.appendReplace$put(builder, (List)destination$iv$iv, df0);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DataFrame.Variable)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.variables(df1).containsKey(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = df1.variables();
        builder = DataFrameUtil.appendReplace$put(builder, (List)destination$iv$iv, df1);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DataFrame.Variable)element$iv$iv;
            boolean bl = false;
            boolean bl3 = !INSTANCE.variables(df0).containsKey(it.getName());
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return DataFrameUtil.appendReplace$put(builder, (List)destination$iv$iv, df1).build();
    }

    @NotNull
    public final Map<String, List<?>> toMap(@NotNull DataFrame df) {
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        HashMap result2 = new HashMap();
        Set<DataFrame.Variable> variables = df.variables();
        for (DataFrame.Variable variable : variables) {
            ((Map)result2).put(variable.getName(), df.get(variable));
        }
        return result2;
    }

    @NotNull
    public final DataFrame fromMap(@NotNull Map<?, ?> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        DataFrame.Builder frameBuilder = new DataFrame.Builder();
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String)) {
                boolean $i$a$-require-DataFrameUtil$fromMap$32 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Map to data-frame: key expected a String but was ");
                Object obj = key;
                Intrinsics.checkNotNull(obj);
                String $i$a$-require-DataFrameUtil$fromMap$32 = stringBuilder.append(Reflection.getOrCreateKotlinClass(obj.getClass()).getSimpleName()).append(" : ").append(key).toString();
                throw new IllegalArgumentException($i$a$-require-DataFrameUtil$fromMap$32.toString());
            }
            if (!(value instanceof List)) {
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("Map to data-frame: value expected a List but was ");
                Object obj = value;
                Intrinsics.checkNotNull(obj);
                String string = stringBuilder.append(Reflection.getOrCreateKotlinClass(obj.getClass()).getSimpleName()).append(" : ").append(value).toString();
                throw new IllegalArgumentException(string.toString());
            }
            frameBuilder.put(DataFrameUtil.createVariable$default(this, (String)key, null, 2, null), (List)value);
        }
        return frameBuilder.build();
    }

    @JvmOverloads
    @NotNull
    public final DataFrame.Variable createVariable(@NotNull String name, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return TransformVar.INSTANCE.isTransformVar(name) ? TransformVar.INSTANCE.get(name) : (Stats.INSTANCE.isStatVar(name) ? Stats.INSTANCE.statVar(name) : (Dummies.INSTANCE.isDummyVar(name) ? Dummies.INSTANCE.newDummy(name) : new DataFrame.Variable(name, DataFrame.Variable.Source.ORIGIN, label)));
    }

    public static /* synthetic */ DataFrame.Variable createVariable$default(DataFrameUtil dataFrameUtil, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        return dataFrameUtil.createVariable(string, string2);
    }

    @NotNull
    public final String getSummaryText(@NotNull DataFrame df) {
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        StringBuilder sb = new StringBuilder();
        for (DataFrame.Variable variable : df.variables()) {
            sb.append(variable.toSummaryString()).append(" numeric: " + df.isNumeric(variable)).append(" size: " + df.get(variable).size()).append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final DataFrame removeAllExcept(@NotNull DataFrame df, @NotNull Set<String> keepNames) {
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        Intrinsics.checkNotNullParameter(keepNames, (String)"keepNames");
        DataFrame.Builder b2 = df.builder();
        for (DataFrame.Variable variable : df.variables()) {
            if (keepNames.contains(variable.getName())) continue;
            b2.remove(variable);
        }
        return b2.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame concat(@NotNull List<DataFrame> dataframes, boolean outer) {
        void $this$reduce$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(dataframes, (String)"dataframes");
        if (!(!((Collection)dataframes).isEmpty())) {
            boolean $i$a$-require-DataFrameUtil$concat$22 = false;
            String $i$a$-require-DataFrameUtil$concat$22 = "Dataframes list should not be empty";
            throw new IllegalArgumentException($i$a$-require-DataFrameUtil$concat$22.toString());
        }
        Iterable $i$a$-require-DataFrameUtil$concat$22 = dataframes;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataFrame dataFrame = (DataFrame)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.toSet((Iterable)it.variables()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void set2;
            Set $i$f$mapTo2 = (Set)iterator$iv.next();
            Set acc = (Set)accumulator$iv;
            boolean bl = false;
            accumulator$iv = outer ? CollectionsKt.union((Iterable)acc, (Iterable)((Iterable)set2)) : CollectionsKt.intersect((Iterable)acc, (Iterable)((Iterable)set2));
        }
        Set variables = (Set)accumulator$iv;
        DataFrame.Builder builder = new DataFrame.Builder();
        Iterable $this$forEach$iv = variables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv2;
            DataFrame.Variable variable = (DataFrame.Variable)element$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = dataframes;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                List list2;
                void df;
                DataFrame dataFrame = (DataFrame)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                if (df.has(variable)) {
                    list2 = df.get(variable);
                } else {
                    int n = df.rowCount();
                    ArrayList<Object> arrayList = new ArrayList<Object>(n);
                    int n2 = 0;
                    while (n2 < n) {
                        int n3;
                        int n4 = n3 = n2++;
                        ArrayList<Object> arrayList2 = arrayList;
                        boolean bl3 = false;
                        arrayList2.add(null);
                    }
                    list2 = arrayList;
                }
                collection.add(list2);
            }
            List values2 = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
            builder.put(variable, values2);
        }
        return builder.build();
    }

    public static /* synthetic */ DataFrame concat$default(DataFrameUtil dataFrameUtil, List list2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return dataFrameUtil.concat(list2, bl);
    }

    @JvmOverloads
    @NotNull
    public final DataFrame.Variable createVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return DataFrameUtil.createVariable$default(this, name, null, 2, null);
    }

    private static final int sortedCopy$lambda$0(DataFrame.Variable o1, DataFrame.Variable o2) {
        return o1.getName().compareTo(o2.getName());
    }

    private static final DataFrame.Builder appendReplace$put(DataFrame.Builder $this$appendReplace_u24put, Collection<DataFrame.Variable> destVars, DataFrame df) {
        DataFrame.Builder builder;
        DataFrame.Builder $this$appendReplace_u24put_u24lambda_u242 = builder = $this$appendReplace_u24put;
        boolean bl = false;
        Iterable $this$forEach$iv = destVars;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataFrame.Variable destVar = (DataFrame.Variable)element$iv;
            boolean bl2 = false;
            DataFrame.Variable srcVar = INSTANCE.findVariableOrFail(df, destVar.getName());
            boolean bl3 = df.isNumeric(srcVar);
            if (bl3) {
                $this$appendReplace_u24put_u24lambda_u242.putNumeric(destVar, df.getNumeric(srcVar));
                continue;
            }
            if (bl3) continue;
            $this$appendReplace_u24put_u24lambda_u242.putDiscrete(destVar, df.get(srcVar));
        }
        return builder;
    }
}

