/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.func;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.func.ExtFunction;
import sarif.export.symbols.ExtSymbol;
import sarif.managers.FunctionsSarifMgr;
import sarif.managers.SymbolTableSarifMgr;

public class SarifFunctionWriter
extends AbstractExtWriter {
    private List<Function> requestedFunctions = new ArrayList<Function>();

    public SarifFunctionWriter(FunctionManager mgr, List<Function> requestedFunctions, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.requestedFunctions = requestedFunctions;
    }

    public void requestFunction(Function next) {
        this.requestedFunctions.add(next);
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genFunctions(monitor);
        this.root.add("functions", (JsonElement)this.objects);
    }

    private void genFunctions(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.requestedFunctions.size());
        for (Function f : this.requestedFunctions) {
            this.addSymbol(f.getSymbol());
            ExtFunction isf = new ExtFunction(f, monitor);
            SarifObject sarif = new SarifObject("Function", FunctionsSarifMgr.KEY, this.getTree(isf), f.getBody());
            this.objects.add(this.getTree(sarif));
            monitor.increment();
        }
    }

    private void addSymbol(Symbol s) {
        Namespace pspace = s.getParentNamespace();
        if (pspace == null) {
            return;
        }
        if (!pspace.isGlobal()) {
            Symbol p = s.getParentSymbol();
            this.addSymbol(p);
        }
        ExtSymbol lib = new ExtSymbol(s);
        SarifObject sarif = new SarifObject("Symbol", SymbolTableSarifMgr.KEY, this.getTree(lib), s.getAddress(), s.getAddress());
        this.objects.add(this.getTree(sarif));
    }

    public JsonArray getResults() {
        return this.objects;
    }
}

