/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.stack;

import db.DBHandle;
import generic.util.FlattenedIterator;
import ghidra.framework.data.OpenMode;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.stack.TraceStackManager;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.LockHold;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceStackManager
implements TraceStackManager,
DBTraceManager {
    protected final DBHandle dbh;
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBTraceThreadManager threadManager;
    protected final DBTraceOverlaySpaceAdapter overlayAdapter;

    public DBTraceStackManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace, DBTraceThreadManager threadManager, DBTraceOverlaySpaceAdapter overlayAdapter) throws VersionException, IOException {
        this.dbh = dbh;
        this.lock = lock;
        this.trace = trace;
        this.threadManager = threadManager;
        this.overlayAdapter = overlayAdapter;
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
    }

    public static PathFilter single(TraceObject seed, Class<? extends TraceObjectInterface> targetIf) {
        PathFilter stackFilter = seed.getSchema().searchFor(targetIf, false);
        if (stackFilter.getSingletonPath() == null) {
            throw new IllegalStateException("Schema doesn't provide a unique " + targetIf.getSimpleName() + " for " + String.valueOf(seed.getCanonicalPath()));
        }
        return stackFilter.getSingletonPattern();
    }

    protected TraceStack doGetOrAddObjectStack(TraceThread thread, long snap, boolean createIfAbsent) {
        TraceObject obj = thread.getObject();
        PathFilter filter = DBTraceStackManager.single(obj, TraceStack.class);
        if (createIfAbsent) {
            try (LockHold hold = this.trace.lockWrite();){
                TraceStack stack = this.trace.getObjectManager().getSuccessor(obj, filter, snap, TraceStack.class);
                if (stack != null) {
                    TraceStack traceStack = stack;
                    return traceStack;
                }
                KeyPath path = obj.getCanonicalPath().extend(filter.getSingletonPath());
                TraceStack traceStack = this.trace.getObjectManager().addStack(path, snap);
                return traceStack;
            }
        }
        try (LockHold hold = this.trace.lockRead();){
            TraceStack traceStack = this.trace.getObjectManager().getSuccessor(obj, filter, snap, TraceStack.class);
            return traceStack;
        }
    }

    protected TraceStack doGetLatestObjectStack(TraceThread thread, long snap) {
        TraceObject obj = thread.getObject();
        KeyPath path = DBTraceStackManager.single(obj, TraceStack.class).getSingletonPath();
        return this.trace.getObjectManager().getLatestSuccessor(obj, path, snap, TraceStack.class);
    }

    @Override
    public TraceStack getStack(TraceThread thread, long snap, boolean createIfAbsent) {
        this.threadManager.assertIsMine(thread);
        return this.doGetOrAddObjectStack(thread, snap, createIfAbsent);
    }

    @Override
    public TraceStack getLatestStack(TraceThread thread, long snap) {
        this.threadManager.assertIsMine(thread);
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            TraceStack traceStack = this.doGetLatestObjectStack(thread, snap);
            return traceStack;
        }
    }

    @Override
    public Iterable<TraceStackFrame> getFramesIn(AddressSetView set) {
        return () -> FlattenedIterator.start((Iterator)set.iterator(), rng -> this.trace.getObjectManager().getObjectsIntersecting(Lifespan.ALL, (AddressRange)rng, "_pc", TraceStackFrame.class).iterator());
    }
}

