/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout.flowchart;

import ghidra.graph.viewer.layout.GridPoint;
import java.util.List;

public abstract class EdgeSegment<E> {
    protected E edge;
    protected List<GridPoint> points;
    protected int pointIndex;
    private int offset;

    public EdgeSegment(E e, List<GridPoint> points, int pointIndex) {
        this.edge = e;
        this.points = points;
        this.pointIndex = pointIndex;
    }

    public E getEdge() {
        return this.edge;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        return String.format("%s,  i = %d, offset = %s", this.edge, this.pointIndex, this.offset);
    }

    public boolean isBackEdge() {
        GridPoint start = this.points.get(0);
        GridPoint end = this.points.get(this.points.size() - 1);
        return start.row >= end.row;
    }

    public boolean startsAt(GridPoint p) {
        return this.points.get(this.pointIndex).equals((Object)p);
    }

    public abstract EdgeSegment<E> nextSegment();

    public abstract EdgeSegment<E> previousSegment();
}

