/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.DialogComponentProvider;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.dialogs.InputDialogListener;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;
import org.apache.commons.lang3.StringUtils;

public abstract class RenameTask {
    protected String newName = null;
    protected String oldName;
    protected String errorMsg = null;
    protected PluginTool tool;
    protected Program program;
    protected DecompilerProvider provider;
    protected ClangToken tokenAtCursor;

    public RenameTask(PluginTool tool, Program program, DecompilerProvider provider, ClangToken token, String old) {
        this.tool = tool;
        this.program = program;
        this.provider = provider;
        this.tokenAtCursor = token;
        this.oldName = old;
    }

    public abstract String getTransactionName();

    public abstract boolean isValid(String var1);

    public abstract void commit() throws DuplicateNameException, InvalidInputException;

    public String getNewName() {
        return this.newName;
    }

    private boolean showDialog(boolean oldNameIsCancel) {
        InputDialogListener listener = new InputDialogListener(){

            public boolean inputIsValid(InputDialog dialog) {
                String name = dialog.getValue();
                if (StringUtils.isBlank((CharSequence)name)) {
                    dialog.setStatusText("Cannot have empty name");
                    return false;
                }
                if ((name = name.trim()).equals(RenameTask.this.oldName)) {
                    RenameTask.this.newName = name;
                    return true;
                }
                boolean res = RenameTask.this.isValid(name);
                if (!res) {
                    dialog.setStatusText(RenameTask.this.errorMsg);
                }
                return res;
            }
        };
        String label = "Rename " + this.oldName + ":";
        InputDialog renameVarDialog = new InputDialog(this.getTransactionName(), new String[]{label}, new String[]{this.oldName}, listener);
        this.tool.showDialog((DialogComponentProvider)renameVarDialog);
        if (renameVarDialog.isCanceled()) {
            return false;
        }
        return !oldNameIsCancel || !this.newName.equals(this.oldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask(boolean oldNameIsCancel) {
        boolean result = this.showDialog(oldNameIsCancel);
        if (!result) {
            return;
        }
        int tx = this.program.startTransaction(this.getTransactionName());
        boolean commit = false;
        try {
            this.commit();
            commit = true;
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Rename Failed", (Object)e.getMessage());
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Rename Failed", (Object)e.getMessage());
        }
        finally {
            this.program.endTransaction(tx, commit);
            if (commit) {
                this.provider.tokenRenamed(this.tokenAtCursor, this.getNewName());
            }
        }
    }

    public static boolean isSymbolInFunction(Function function, String name) {
        SymbolTable symbolTable = function.getProgram().getSymbolTable();
        return !symbolTable.getSymbols(name, (Namespace)function).isEmpty();
    }
}

