/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.comments;

import generic.theme.GAttributes;
import generic.theme.GColor;
import generic.theme.Gui;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CommentHistory;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.util.DateUtils;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

class CommentHistoryPanel
extends JPanel {
    private static final String NO_HISTORY = "No History Found";
    private SimpleAttributeSet userAttrs;
    private SimpleAttributeSet dateAttrs;
    private SimpleAttributeSet textAttrSet;
    private SimpleAttributeSet tabAttrSet;
    private StyledDocument doc;
    private JTextPane textPane;
    private CommentType commentType;

    CommentHistoryPanel(CommentType commentType, CodeUnit cu) {
        super(new BorderLayout());
        this.setUpAttributes();
        this.commentType = commentType;
        this.create();
        this.showCommentHistory(cu.getProgram(), cu.getMinAddress());
    }

    private void showCommentHistory(Program program, Address addr) {
        this.textPane.setText("");
        CommentHistory[] historyItems = program.getListing().getCommentHistory(addr, this.commentType);
        try {
            if (historyItems.length == 0) {
                this.doc.insertString(0, NO_HISTORY, null);
                this.doc.setCharacterAttributes(0, NO_HISTORY.length(), this.textAttrSet, true);
                return;
            }
            for (CommentHistory historyItem : historyItems) {
                this.formatHistory(historyItem);
            }
        }
        catch (BadLocationException e) {
            Msg.debug((Object)this, (Object)"Error setting comment text field text", (Throwable)e);
        }
        this.textPane.setCaretPosition(0);
    }

    private void create() {
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.setFocusable(false);
        this.add((Component)this.textPane, "Center");
        this.doc = this.textPane.getStyledDocument();
    }

    private void formatHistory(CommentHistory history) throws BadLocationException {
        int offset = this.doc.getLength();
        Object userName = history.getUserName();
        if (offset > 0) {
            userName = "\n" + (String)userName;
        }
        this.doc.insertString(offset, (String)userName, this.userAttrs);
        offset = this.doc.getLength();
        this.doc.insertString(offset, "\t" + DateUtils.formatDateTimestamp((Date)history.getModificationDate()), this.dateAttrs);
        this.doc.setParagraphAttributes(offset, 1, this.tabAttrSet, false);
        offset = this.doc.getLength();
        this.doc.insertString(offset, "\n" + history.getComments() + "\n", this.textAttrSet);
    }

    private void setUpAttributes() {
        Font bold = Gui.getFont((String)"font.standard.bold");
        Font monospaced = Gui.getFont((String)"font.monospaced");
        this.textAttrSet = new GAttributes(monospaced, (Color)new GColor("color.fg.plugin.comments.history.text"));
        this.userAttrs = new GAttributes(bold, (Color)new GColor("color.fg.plugin.comments.history.user"));
        this.dateAttrs = new GAttributes(bold, (Color)new GColor("color.fg.plugin.comments.history.date"));
        this.tabAttrSet = new SimpleAttributeSet();
        TabStop tabs = new TabStop(100.0f, 0, 0);
        StyleConstants.setTabSet(this.tabAttrSet, new TabSet(new TabStop[]{tabs}));
    }

    public String getHistory() {
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)"This should never happen as the indexes came from the document!");
            return "";
        }
    }
}

