/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class PhysicalMemoryRun
implements StructConverter {
    public static final String NAME = "PAGEDUMP_PHYS_MEM_RUN";
    private long basePage;
    private long pageCount;
    private DumpFileReader reader;
    private long index;

    PhysicalMemoryRun(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setBasePage(this.reader.readNextPointer());
        this.setPageCount(this.reader.readNextPointer());
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "BasePage", null);
        struct.add(DWORD, 4, "PageCount", null);
        struct.setCategoryPath(new CategoryPath("/PDMP"));
        return struct;
    }

    public long getBasePage() {
        return this.basePage;
    }

    public void setBasePage(long basePage) {
        this.basePage = basePage;
    }

    public long getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(long pageCount) {
        this.pageCount = pageCount;
    }
}

