/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.cache.AbstractFilesCache;

public class DefaultFilesCache
extends AbstractFilesCache {
    private static final float LOAD_FACTOR = 0.75f;
    private static final int INITIAL_CAPACITY = 200;
    private final ConcurrentMap<FileSystem, ConcurrentMap<FileName, FileObject>> fileSystemCache = new ConcurrentHashMap<FileSystem, ConcurrentMap<FileName, FileObject>>(10);

    @Override
    public void clear(FileSystem filesystem) {
        Map files = (Map)this.fileSystemCache.remove(filesystem);
        if (files != null) {
            files.clear();
        }
    }

    @Override
    public void close() {
        super.close();
        this.fileSystemCache.clear();
    }

    @Override
    public FileObject getFile(FileSystem filesystem, FileName name) {
        Map files = (Map)this.fileSystemCache.get(filesystem);
        if (files == null) {
            return null;
        }
        return (FileObject)files.get(name);
    }

    protected ConcurrentMap<FileName, FileObject> getOrCreateFilesystemCache(FileSystem fileSystem) {
        ConcurrentMap files = (ConcurrentMap)this.fileSystemCache.get(fileSystem);
        while (files == null) {
            files = this.fileSystemCache.computeIfAbsent(fileSystem, k -> new ConcurrentHashMap(200, 0.75f, Math.max(2, Runtime.getRuntime().availableProcessors()) / 2));
        }
        return files;
    }

    @Override
    public void putFile(FileObject file) {
        ConcurrentMap<FileName, FileObject> files = this.getOrCreateFilesystemCache(file.getFileSystem());
        files.put(file.getName(), file);
    }

    @Override
    public boolean putFileIfAbsent(FileObject file) {
        ConcurrentMap<FileName, FileObject> files = this.getOrCreateFilesystemCache(file.getFileSystem());
        return files.putIfAbsent(file.getName(), file) == null;
    }

    @Override
    public void removeFile(FileSystem filesystem, FileName name) {
        Map files = (Map)this.fileSystemCache.get(filesystem);
        if (files != null) {
            files.remove(name);
        }
    }
}

