/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { ToolDefinition } from './types.js';
export declare const GLOB_TOOL_NAME = "glob";
export declare const GREP_TOOL_NAME = "grep_search";
export declare const LS_TOOL_NAME = "list_directory";
export declare const READ_FILE_TOOL_NAME = "read_file";
export declare const SHELL_TOOL_NAME = "run_shell_command";
export declare const WRITE_FILE_TOOL_NAME = "write_file";
export declare const READ_FILE_DEFINITION: ToolDefinition;
export declare const WRITE_FILE_DEFINITION: ToolDefinition;
export declare const GREP_DEFINITION: ToolDefinition;
export declare const GLOB_DEFINITION: ToolDefinition;
export declare const LS_DEFINITION: ToolDefinition;
/**
 * Generates the platform-specific description for the shell tool.
 */
export declare function getShellToolDescription(enableInteractiveShell: boolean, enableEfficiency: boolean): string;
/**
 * Returns the platform-specific description for the 'command' parameter.
 */
export declare function getCommandDescription(): string;
/**
 * Returns the tool definition for the shell tool, customized for the platform.
 */
export declare function getShellDefinition(enableInteractiveShell: boolean, enableEfficiency: boolean): ToolDefinition;
