/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.api;

import com.adobe.epubcheck.api.EpubCheck;
import com.adobe.epubcheck.opf.ValidationContext;
import java.io.File;
import java.io.IOException;
import org.w3c.epubcheck.core.Checker;

public class EpubCheckFactory {
    private static final EpubCheckFactory instance = new EpubCheckFactory();

    public static EpubCheckFactory getInstance() {
        return instance;
    }

    public Checker newInstance(ValidationContext context) {
        if (context.path.startsWith("http://") || context.path.startsWith("https://")) {
            try {
                return new EpubCheck(context.resourceProvider.openStream(context.url), context.report, context.path, context.profile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new EpubCheck(new File(context.path), context.report, context.profile);
    }
}

