/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.CssBorderBottomColor;
import org.w3c.css.properties.css3.CssBorderBottomStyle;
import org.w3c.css.properties.css3.CssBorderBottomWidth;
import org.w3c.css.properties.css3.CssBorderColor;
import org.w3c.css.properties.css3.CssBorderLeftColor;
import org.w3c.css.properties.css3.CssBorderLeftStyle;
import org.w3c.css.properties.css3.CssBorderLeftWidth;
import org.w3c.css.properties.css3.CssBorderRightColor;
import org.w3c.css.properties.css3.CssBorderRightStyle;
import org.w3c.css.properties.css3.CssBorderRightWidth;
import org.w3c.css.properties.css3.CssBorderStyle;
import org.w3c.css.properties.css3.CssBorderTopColor;
import org.w3c.css.properties.css3.CssBorderTopStyle;
import org.w3c.css.properties.css3.CssBorderTopWidth;
import org.w3c.css.properties.css3.CssBorderWidth;
import org.w3c.css.properties.css3.CssColor;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBorder
extends org.w3c.css.properties.css.CssBorder {
    public CssBorder() {
        this.value = initial;
    }

    public CssBorder(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssBorder(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        CssValueList valueList = new CssValueList();
        SideValues values = CssBorder.parseBorderSide(ac, expression, check, this);
        this.shorthand = true;
        if (values.color != null) {
            valueList.add(values.color);
            this.borderColor = new CssBorderColor();
            this.borderColor.bottom = new CssBorderBottomColor();
            this.borderColor.bottom.value = values.color;
            this.borderColor.top = new CssBorderTopColor();
            this.borderColor.top.value = values.color;
            this.borderColor.left = new CssBorderLeftColor();
            this.borderColor.left.value = values.color;
            this.borderColor.right = new CssBorderRightColor();
            this.borderColor.right.value = values.color;
        }
        if (values.style != null) {
            valueList.add(values.style);
            this.borderStyle = new CssBorderStyle();
            this.borderStyle.bottom = new CssBorderBottomStyle();
            this.borderStyle.bottom.value = values.style;
            this.borderStyle.top = new CssBorderTopStyle();
            this.borderStyle.top.value = values.style;
            this.borderStyle.left = new CssBorderLeftStyle();
            this.borderStyle.left.value = values.style;
            this.borderStyle.right = new CssBorderRightStyle();
            this.borderStyle.right.value = values.style;
        }
        if (values.width != null) {
            valueList.add(values.width);
            this.borderWidth = new CssBorderWidth();
            this.borderWidth.bottom = new CssBorderBottomWidth();
            this.borderWidth.bottom.value = values.width;
            this.borderWidth.top = new CssBorderTopWidth();
            this.borderWidth.top.value = values.width;
            this.borderWidth.left = new CssBorderLeftWidth();
            this.borderWidth.left.value = values.width;
            this.borderWidth.right = new CssBorderRightWidth();
            this.borderWidth.right.value = values.width;
        }
        this.value = valueList;
    }

    protected static SideValues parseBorderSide(ApplContext ac, CssExpression expression, boolean check, CssProperty caller) throws InvalidParamException {
        if (check && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue _width = null;
        CssValue _style = null;
        CssValue _color = null;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getCheckableValue().checkEqualsZero(ac, caller);
                    _width = val;
                    break;
                }
                case 6: {
                    val.getCheckableValue().checkPositiveness(ac, caller);
                    _width = val;
                    break;
                }
                case 15: {
                    org.w3c.css.values.CssColor c = new org.w3c.css.values.CssColor();
                    c.setShortRGBColor(ac, val.getHashIdent().toString());
                    _color = val;
                    break;
                }
                case 3: {
                    _color = val;
                    break;
                }
                case 0: {
                    CssIdent id = val.getIdent();
                    if (transparent.equals(id)) {
                        _color = transparent;
                        break;
                    }
                    if (CssIdent.isCssWide(id)) {
                        if (expression.getCount() > 1) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        _width = val;
                        _style = val;
                        _color = val;
                        break;
                    }
                    CssIdent match = CssBorderWidth.getAllowedIdent(id);
                    if (match != null) {
                        _width = val;
                        break;
                    }
                    match = CssBorderStyle.getAllowedIdent(id);
                    if (match != null) {
                        _style = val;
                        break;
                    }
                    CssExpression nex = new CssExpression();
                    nex.addValue(val);
                    CssColor cssColor = new CssColor(ac, nex, false);
                    _color = cssColor.getValue();
                    break;
                }
                case 11: {
                    CssExpression nex = new CssExpression();
                    nex.addValue(val);
                    CssColor cssColor = new CssColor(ac, nex, false);
                    _color = cssColor.getValue();
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
            }
            expression.next();
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        return new SideValues(_width, _style, _color);
    }

    protected static class SideValues {
        CssValue width;
        CssValue style;
        CssValue color;

        SideValues(CssValue width, CssValue style, CssValue color) {
            this.width = width;
            this.style = style;
            this.color = color;
        }
    }
}

