/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.impl.SilentChangeVetoer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.changes.ChangesUtil;
import com.intellij.util.ThreeState;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/daemon/VcsSilentChangeVetoer;", "Lcom/intellij/codeInsight/daemon/impl/SilentChangeVetoer;", "<init>", "()V", "canChangeFileSilently", "Lcom/intellij/util/ThreeState;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.impl"})
public final class VcsSilentChangeVetoer
implements SilentChangeVetoer {
    @NotNull
    public ThreeState canChangeFileSilently(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        boolean vcsIsThinking;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (ProjectLevelVcsManager.Companion.getInstance(project).getVcsFor(virtualFile) == null) {
            return ThreeState.UNSURE;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        FilePath path = filePath;
        boolean bl = vcsIsThinking = !VcsDirtyScopeManager.getInstance((Project)project).whatFilesDirty((Collection)CollectionsKt.listOf((Object)path)).isEmpty();
        if (vcsIsThinking) {
            return ThreeState.UNSURE;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
        FileStatus status = fileStatus;
        if (status == FileStatus.UNKNOWN) {
            return ThreeState.UNSURE;
        }
        if (status == FileStatus.MERGE || ChangesUtil.isMergeConflict((FileStatus)status)) {
            return ThreeState.NO;
        }
        return ThreeState.Companion.fromBoolean(status != FileStatus.NOT_CHANGED);
    }
}

