/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.searchEverywhere.frontend;

import com.intellij.ide.actions.searcheverywhere.SplitSearchListener;
import com.intellij.platform.searchEverywhere.providers.SeLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nJ\"\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0012J\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/searchEverywhere/frontend/SeSearchStatePublisher;", "", "<init>", "()V", "listeners", "", "Lcom/intellij/ide/actions/searcheverywhere/SplitSearchListener;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "currentSearchId", "", "searchStarted", "", "searchId", "pattern", "tabId", "elementsAdded", "uuidToElement", "", "elementsRemoved", "count", "", "searchStoppedProducingResults", "isFinished", "", "addListener", "listener", "removeListener", "intellij.platform.searchEverywhere.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSeSearchStatePublisher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeSearchStatePublisher.kt\ncom/intellij/platform/searchEverywhere/frontend/SeSearchStatePublisher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1869#2,2:77\n1869#2,2:79\n1869#2,2:81\n1869#2,2:83\n*S KotlinDebug\n*F\n+ 1 SeSearchStatePublisher.kt\ncom/intellij/platform/searchEverywhere/frontend/SeSearchStatePublisher\n*L\n24#1:77,2\n35#1:79,2\n46#1:81,2\n58#1:83,2\n*E\n"})
public final class SeSearchStatePublisher {
    @NotNull
    private final List<SplitSearchListener> listeners = new ArrayList();
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();
    @Nullable
    private String currentSearchId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void searchStarted(@NotNull String searchId, @NotNull String pattern, @NotNull String tabId) {
        Intrinsics.checkNotNullParameter((Object)searchId, (String)"searchId");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            String string = this.currentSearchId;
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                this.searchStoppedProducingResults(it, -1, true);
            }
            SeLog.Companion.log(SeLog.LISTENERS, () -> SeSearchStatePublisher.searchStarted$lambda$3$lambda$1(searchId, pattern, tabId));
            this.currentSearchId = searchId;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SplitSearchListener it = (SplitSearchListener)element$iv;
                boolean bl3 = false;
                it.searchStarted(pattern, tabId);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void elementsAdded(@NotNull String searchId, @NotNull Map<String, ? extends Object> uuidToElement) {
        Intrinsics.checkNotNullParameter((Object)searchId, (String)"searchId");
        Intrinsics.checkNotNullParameter(uuidToElement, (String)"uuidToElement");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)searchId, (Object)this.currentSearchId)) {
                SeLog.Companion.log(SeLog.LISTENERS, () -> SeSearchStatePublisher.elementsAdded$lambda$7$lambda$4(searchId, this));
            } else {
                SeLog.Companion.log(SeLog.LISTENERS, () -> SeSearchStatePublisher.elementsAdded$lambda$7$lambda$5(searchId, uuidToElement));
                Iterable $this$forEach$iv = this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SplitSearchListener it = (SplitSearchListener)element$iv;
                    boolean bl2 = false;
                    it.elementsAdded(uuidToElement);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void elementsRemoved(@NotNull String searchId, int count) {
        Intrinsics.checkNotNullParameter((Object)searchId, (String)"searchId");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)searchId, (Object)this.currentSearchId)) {
                SeLog.Companion.log(SeLog.LISTENERS, () -> SeSearchStatePublisher.elementsRemoved$lambda$11$lambda$8(searchId, this));
            } else {
                SeLog.Companion.log(SeLog.LISTENERS, () -> SeSearchStatePublisher.elementsRemoved$lambda$11$lambda$9(searchId, count));
                Iterable $this$forEach$iv = this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SplitSearchListener it = (SplitSearchListener)element$iv;
                    boolean bl2 = false;
                    it.elementsRemoved(count);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void searchStoppedProducingResults(@NotNull String searchId, int count, boolean isFinished) {
        Intrinsics.checkNotNullParameter((Object)searchId, (String)"searchId");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.currentSearchId != null && !Intrinsics.areEqual((Object)searchId, (Object)this.currentSearchId)) {
                SeLog.Companion.log(SeLog.LISTENERS, () -> SeSearchStatePublisher.searchStoppedProducingResults$lambda$15$lambda$12(searchId, this));
            } else {
                SeLog.Companion.log(SeLog.LISTENERS, () -> SeSearchStatePublisher.searchStoppedProducingResults$lambda$15$lambda$13(isFinished, searchId, count));
                Iterable $this$forEach$iv = this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SplitSearchListener it = (SplitSearchListener)element$iv;
                    boolean bl2 = false;
                    it.searchFinished(count);
                }
                if (isFinished) {
                    this.currentSearchId = null;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(@NotNull SplitSearchListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.listeners.add(listener);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(@NotNull SplitSearchListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.listeners.remove(listener);
        }
        finally {
            lock.unlock();
        }
    }

    private static final String searchStarted$lambda$3$lambda$1(String $searchId, String $pattern, String $tabId) {
        return "Search started: " + $searchId + ", " + $pattern + ", " + $tabId;
    }

    private static final String elementsAdded$lambda$7$lambda$4(String $searchId, SeSearchStatePublisher this$0) {
        return "Added elements tried to be published to listeners for wrong search: " + $searchId + ", current search: " + this$0.currentSearchId;
    }

    private static final String elementsAdded$lambda$7$lambda$5(String $searchId, Map $uuidToElement) {
        return "Elements added: " + $searchId + ", " + $uuidToElement.size();
    }

    private static final String elementsRemoved$lambda$11$lambda$8(String $searchId, SeSearchStatePublisher this$0) {
        return "Removed elements tried to be published to listeners for wrong search: " + $searchId + ", current search: " + this$0.currentSearchId;
    }

    private static final String elementsRemoved$lambda$11$lambda$9(String $searchId, int $count) {
        return "Elements removed: " + $searchId + ", " + $count;
    }

    private static final String searchStoppedProducingResults$lambda$15$lambda$12(String $searchId, SeSearchStatePublisher this$0) {
        return "Finished search tried to be published to listeners for wrong search: " + $searchId + ", current search: " + this$0.currentSearchId;
    }

    private static final String searchStoppedProducingResults$lambda$15$lambda$13(boolean $isFinished, String $searchId, int $count) {
        return "Search " + ($isFinished ? "stopped" : "paused") + " producing results: " + $searchId + ", " + $count;
    }
}

