/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.diagnostics;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.diagnostics.IMetricConsumer;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/TimeLimitOnIntervalConsumer;", "Lcom/jetbrains/rd/platform/diagnostics/IMetricConsumer;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "watchdogName", "", "timeLimit", "Ljava/time/Duration;", "observationInterval", "<init>", "(Lcom/intellij/openapi/diagnostic/Logger;Ljava/lang/String;Ljava/time/Duration;Ljava/time/Duration;)V", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getWatchdogName", "()Ljava/lang/String;", "currentIntervalElapsed", "", "currentIntervalStart", "observationIntervalMs", "timeLimitMs", "clearCurrentInterval", "", "consumeValue", "value", "", "comment", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nHotspotWatchdog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotspotWatchdog.kt\ncom/jetbrains/rd/platform/diagnostics/TimeLimitOnIntervalConsumer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,300:1\n1#2:301\n*E\n"})
final class TimeLimitOnIntervalConsumer
implements IMetricConsumer {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String watchdogName;
    private long currentIntervalElapsed;
    private long currentIntervalStart;
    private final long observationIntervalMs;
    private final long timeLimitMs;

    public TimeLimitOnIntervalConsumer(@NotNull Logger logger, @NotNull String watchdogName, @NotNull Duration timeLimit, @NotNull Duration observationInterval) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)watchdogName, (String)"watchdogName");
        Intrinsics.checkNotNullParameter((Object)timeLimit, (String)"timeLimit");
        Intrinsics.checkNotNullParameter((Object)observationInterval, (String)"observationInterval");
        this.logger = logger;
        this.watchdogName = watchdogName;
        this.observationIntervalMs = observationInterval.toMillis();
        this.timeLimitMs = timeLimit.toMillis();
        this.clearCurrentInterval();
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String getWatchdogName() {
        return this.watchdogName;
    }

    public final void clearCurrentInterval() {
        this.currentIntervalStart = System.nanoTime();
        this.currentIntervalElapsed = 0L;
    }

    @Override
    public void consumeValue(double value, @Nullable String comment) {
        long currentValueMs = (long)value;
        this.currentIntervalElapsed += currentValueMs;
        long currentIntervalDuration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.currentIntervalStart);
        if (currentIntervalDuration > this.observationIntervalMs) {
            this.clearCurrentInterval();
            if (currentValueMs <= this.timeLimitMs) {
                return;
            }
            this.currentIntervalElapsed = currentValueMs;
        }
        if (this.currentIntervalElapsed > this.timeLimitMs) {
            Exception exception;
            String string = comment;
            if (string != null) {
                String it = string;
                boolean bl = false;
                exception = new Exception(it);
            } else {
                exception = null;
            }
            Exception exception2 = exception;
            this.logger.error(this.watchdogName + ": The watched operations took " + this.currentIntervalElapsed + " over last " + currentIntervalDuration, (Throwable)exception2);
            this.clearCurrentInterval();
        }
    }
}

