/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language.identifier;

import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Languages;
import org.languagetool.language.identifier.DefaultLanguageIdentifier;
import org.languagetool.language.identifier.LanguageIdentifier;
import org.languagetool.language.identifier.SimpleLanguageIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LanguageIdentifierService {
    INSTANCE;

    private static final Logger log;
    private LanguageIdentifier defaultIdentifier = null;
    private LanguageIdentifier simpleIdentifier = null;

    public synchronized LanguageIdentifier getDefaultLanguageIdentifier(int maxLength, @Nullable File ngramLangIdentData, @Nullable File fasttextBinary, @Nullable File fasttextModel) {
        if (this.defaultIdentifier == null) {
            DefaultLanguageIdentifier defaultIdentifier = maxLength > 0 ? new DefaultLanguageIdentifier(maxLength) : new DefaultLanguageIdentifier();
            defaultIdentifier.enableNgrams(ngramLangIdentData);
            defaultIdentifier.enableFasttext(fasttextBinary, fasttextModel);
            this.defaultIdentifier = defaultIdentifier;
        }
        return this.defaultIdentifier;
    }

    public synchronized LanguageIdentifier getSimpleLanguageIdentifier(@Nullable List<String> preferredLangCodes) {
        if (this.simpleIdentifier == null) {
            this.simpleIdentifier = preferredLangCodes == null ? new SimpleLanguageIdentifier() : new SimpleLanguageIdentifier(preferredLangCodes);
        }
        return this.simpleIdentifier;
    }

    @Nullable
    public LanguageIdentifier getInitialized() {
        if (this.defaultIdentifier != null) {
            return this.defaultIdentifier;
        }
        if (this.simpleIdentifier != null) {
            return this.simpleIdentifier;
        }
        return null;
    }

    public boolean canLanguageBeDetected(String langCode, List<String> additionalLanguageCodes) {
        return Languages.isLanguageSupported(langCode) || additionalLanguageCodes.contains(langCode);
    }

    public LanguageIdentifierService clearLanguageIdentifier(String type) {
        switch (type) {
            case "default": {
                this.defaultIdentifier = null;
                break;
            }
            case "simple": {
                this.simpleIdentifier = null;
                break;
            }
            case "both": {
                this.simpleIdentifier = null;
                this.defaultIdentifier = null;
                break;
            }
        }
        return this;
    }

    static {
        log = LoggerFactory.getLogger(LanguageIdentifierService.class);
    }
}

