/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MergeSession;
import com.intellij.openapi.vcs.merge.MergeSessionEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.util.GitFileUtils;
import git4idea.util.StringScanner;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMergeProvider
implements MergeProvider2 {
    private static final Logger LOG = Logger.getInstance(GitMergeProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<VirtualFile> myReverseRoots;

    private GitMergeProvider(@NotNull Project project, @NotNull Set<VirtualFile> reverseRoots) {
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(0);
        }
        if (reverseRoots == null) {
            GitMergeProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myReverseRoots = reverseRoots;
    }

    public GitMergeProvider(@NotNull Project project, boolean reverse) {
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(2);
        }
        this(project, GitMergeProvider.findReverseRoots(project, reverse ? ReverseRequest.REVERSE : ReverseRequest.FORWARD));
    }

    @NotNull
    public static MergeProvider detect(@NotNull Project project) {
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(3);
        }
        return new GitMergeProvider(project, GitMergeProvider.findReverseRoots(project, ReverseRequest.DETECT));
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NotNull
    private static Set<VirtualFile> findReverseRoots(@NotNull Project project, @NotNull ReverseRequest reverseOrDetect) {
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(5);
        }
        if (reverseOrDetect == null) {
            GitMergeProvider.$$$reportNull$$$0(6);
        }
        if (Registry.is((String)"git.do.not.swap.merge.conflict.sides")) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                GitMergeProvider.$$$reportNull$$$0(7);
            }
            return set;
        }
        HashSet<VirtualFile> reverseMap = new HashSet<VirtualFile>();
        for (GitRepository repository2 : GitUtil.getRepositoryManager(project).getRepositories()) {
            boolean reverse;
            if (reverseOrDetect == ReverseRequest.DETECT) {
                reverse = GitMergeUtil.isReverseRoot(repository2);
            } else {
                boolean bl = reverse = reverseOrDetect == ReverseRequest.REVERSE;
            }
            if (!reverse) continue;
            reverseMap.add(repository2.getRoot());
        }
        HashSet<VirtualFile> hashSet = reverseMap;
        if (hashSet == null) {
            GitMergeProvider.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public MergeData loadRevisions(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(9);
        }
        VirtualFile root = GitUtil.getRootForFile(this.myProject, file);
        FilePath path = VcsUtil.getFilePath((VirtualFile)file);
        MergeData mergeData = GitMergeUtil.loadMergeData(this.myProject, root, path, this.myReverseRoots.contains(root));
        if (mergeData == null) {
            GitMergeProvider.$$$reportNull$$$0(10);
        }
        return mergeData;
    }

    public void conflictResolvedForFile(@NotNull VirtualFile file) {
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(11);
        }
        try {
            GitFileUtils.addFilesForce(this.myProject, GitUtil.getRootForFile(this.myProject, file), Collections.singletonList(file));
        }
        catch (VcsException e) {
            LOG.error("Confirming conflict resolution failed", (Throwable)e);
        }
    }

    public boolean isBinary(@NotNull VirtualFile file) {
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(12);
        }
        return file.getFileType().isBinary();
    }

    @NotNull
    public MergeSession createMergeSession(@NotNull List<VirtualFile> files) {
        if (files == null) {
            GitMergeProvider.$$$reportNull$$$0(13);
        }
        MergeSession mergeSession = (MergeSession)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> new MyMergeSession(files), GitBundle.message((String)"merge.progress.indicator.loading.unmerged.files.title", (Object[])new Object[0]), true, this.myProject);
        if (mergeSession == null) {
            GitMergeProvider.$$$reportNull$$$0(14);
        }
        return mergeSession;
    }

    public MergeDialogCustomizer createDefaultMergeDialogCustomizer() {
        return new GitDefaultMergeDialogCustomizer(this.myProject);
    }

    @NlsContexts.ColumnName
    @NotNull
    public static String calcColumnName(boolean isTheirs, @NlsSafe @Nullable String branchName) {
        if (isTheirs) {
            if (branchName != null) {
                String string = GitBundle.message((String)"merge.tool.column.theirs.with.branch.status", (Object[])new Object[]{branchName});
                if (string == null) {
                    GitMergeProvider.$$$reportNull$$$0(15);
                }
                return string;
            }
            String string = GitBundle.message((String)"merge.tool.column.theirs.status", (Object[])new Object[0]);
            if (string == null) {
                GitMergeProvider.$$$reportNull$$$0(16);
            }
            return string;
        }
        if (branchName != null) {
            String string = GitBundle.message((String)"merge.tool.column.yours.with.branch.status", (Object[])new Object[]{branchName});
            if (string == null) {
                GitMergeProvider.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = GitBundle.message((String)"merge.tool.column.yours.status", (Object[])new Object[0]);
        if (string == null) {
            GitMergeProvider.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 10, 14, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reverseRoots";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/merge/GitMergeProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reverseOrDetect";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/merge/GitMergeProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findReverseRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRevisions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeSession";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calcColumnName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findReverseRoots";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadRevisions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "conflictResolvedForFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isBinary";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createMergeSession";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 10, 14, 15, 16, 17, 18 -> new IllegalStateException(string);
        };
    }

    private static enum ReverseRequest {
        REVERSE,
        FORWARD,
        DETECT;

    }

    private class MyMergeSession
    implements MergeSessionEx {
        private final Map<VirtualFile, GitConflict> myConflicts = new HashMap<VirtualFile, GitConflict>();
        private final String currentBranchName;
        private final String mergeHeadBranchName;

        MyMergeSession(List<VirtualFile> filesToMerge) {
            try {
                Map<GitRepository, List<VirtualFile>> filesByRoot = GitUtil.sortFilesByRepository(GitMergeProvider.this.myProject, filesToMerge);
                for (Map.Entry<GitRepository, List<VirtualFile>> e : filesByRoot.entrySet()) {
                    HashMap<String, Conflict> cs = new HashMap<String, Conflict>();
                    VirtualFile root = e.getKey().getRoot();
                    List<VirtualFile> files = e.getValue();
                    GitLineHandler h = new GitLineHandler(GitMergeProvider.this.myProject, root, GitCommand.LS_FILES);
                    h.setStdoutSuppressed(true);
                    h.setSilent(true);
                    h.addParameters("--exclude-standard", "--unmerged", "-t", "-z");
                    h.endOptions();
                    String output2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
                    StringScanner s = new StringScanner(output2);
                    while (s.hasMoreData()) {
                        if (!"M".equals(s.spaceToken())) {
                            s.boundedToken('\u0000');
                            continue;
                        }
                        s.spaceToken();
                        s.spaceToken();
                        int source = Integer.parseInt(s.tabToken());
                        String file = s.boundedToken('\u0000');
                        Conflict c = (Conflict)cs.get(file);
                        if (c == null) {
                            c = new Conflict();
                            c.myRoot = root;
                            cs.put(file, c);
                        }
                        if (source == 3) {
                            c.myStatusTheirs = GitConflict.Status.MODIFIED;
                            continue;
                        }
                        if (source == 2) {
                            c.myStatusYours = GitConflict.Status.MODIFIED;
                            continue;
                        }
                        if (source == 1) continue;
                        throw new IllegalStateException("Unknown revision " + source + " for the file: " + file);
                    }
                    for (VirtualFile f : files) {
                        String path = VcsFileUtil.relativePath((VirtualFile)root, (VirtualFile)f);
                        Conflict c = (Conflict)cs.get(path);
                        if (c == null) {
                            LOG.error(String.format("The conflict not found for file: %s(%s)%nFull ls-files output: %n%s%nAll files: %n%s", f.getPath(), path, output2, files));
                            continue;
                        }
                        c.myFile = f;
                        if (c.myStatusTheirs == null) {
                            c.myStatusTheirs = GitConflict.Status.DELETED;
                        }
                        if (c.myStatusYours == null) {
                            c.myStatusYours = GitConflict.Status.DELETED;
                        }
                        this.myConflicts.put(f, new GitConflict(root, VcsUtil.getFilePath((VirtualFile)f), c.myStatusYours, c.myStatusTheirs));
                    }
                }
                this.currentBranchName = GitDefaultMergeDialogCustomizerKt.getSingleCurrentBranchName(filesByRoot.keySet());
                this.mergeHeadBranchName = GitDefaultMergeDialogCustomizerKt.getSingleMergeBranchName(filesByRoot.keySet());
            }
            catch (VcsException ex) {
                throw new IllegalStateException("The git operation should not fail in this context", ex);
            }
        }

        public ColumnInfo @NotNull [] getMergeInfoColumns() {
            ColumnInfo[] columnInfoArray = new ColumnInfo[]{new StatusColumn(false, this.currentBranchName), new StatusColumn(true, this.mergeHeadBranchName)};
            if (columnInfoArray == null) {
                MyMergeSession.$$$reportNull$$$0(0);
            }
            return columnInfoArray;
        }

        public boolean canMerge(@NotNull VirtualFile file) {
            GitConflict c;
            if (file == null) {
                MyMergeSession.$$$reportNull$$$0(1);
            }
            return (c = this.myConflicts.get(file)) != null && !file.isDirectory();
        }

        public void conflictResolvedForFile(@NotNull VirtualFile file, @NotNull MergeSession.Resolution resolution) {
            if (file == null) {
                MyMergeSession.$$$reportNull$$$0(2);
            }
            if (resolution == null) {
                MyMergeSession.$$$reportNull$$$0(3);
            }
            this.conflictResolvedForFiles(Collections.singletonList(file), resolution);
        }

        public void conflictResolvedForFiles(@NotNull List<? extends VirtualFile> files, @NotNull MergeSession.Resolution resolution) {
            if (files == null) {
                MyMergeSession.$$$reportNull$$$0(4);
            }
            if (resolution == null) {
                MyMergeSession.$$$reportNull$$$0(5);
            }
            MultiMap<VirtualFile, GitConflict> byRoot = this.groupConflictsByRoot(files);
            for (VirtualFile root : byRoot.keySet()) {
                Collection conflicts = byRoot.get((Object)root);
                GitConflict.ConflictSide resolutionSide = resolution != MergeSession.Resolution.Merged ? this.getAcceptedConflictSide(resolution, root) : null;
                try {
                    GitMergeUtil.markConflictResolved(GitMergeProvider.this.myProject, root, conflicts, resolutionSide);
                }
                catch (VcsException e) {
                    LOG.error(String.format("Unexpected exception during the git operation. Files - %s", ContainerUtil.map((Collection)conflicts, GitConflict::getFilePath)), (Throwable)e);
                }
            }
        }

        public void acceptFilesRevisions(@NotNull List<? extends VirtualFile> files, @NotNull MergeSession.Resolution resolution) throws VcsException {
            if (files == null) {
                MyMergeSession.$$$reportNull$$$0(6);
            }
            if (resolution == null) {
                MyMergeSession.$$$reportNull$$$0(7);
            }
            assert (resolution == MergeSession.Resolution.AcceptedYours || resolution == MergeSession.Resolution.AcceptedTheirs);
            MultiMap<VirtualFile, GitConflict> byRoot = this.groupConflictsByRoot(files);
            for (VirtualFile root : byRoot.keySet()) {
                Collection conflicts = byRoot.get((Object)root);
                GitConflict.ConflictSide conflictSide = this.getAcceptedConflictSide(resolution, root);
                GitMergeUtil.acceptOneVersion(GitMergeProvider.this.myProject, root, conflicts, conflictSide);
            }
        }

        @NotNull
        private GitConflict.ConflictSide getAcceptedConflictSide(@NotNull MergeSession.Resolution resolution, @NotNull VirtualFile root) {
            if (resolution == null) {
                MyMergeSession.$$$reportNull$$$0(8);
            }
            if (root == null) {
                MyMergeSession.$$$reportNull$$$0(9);
            }
            assert (resolution == MergeSession.Resolution.AcceptedYours || resolution == MergeSession.Resolution.AcceptedTheirs);
            boolean isReversed = GitMergeProvider.this.myReverseRoots.contains(root);
            boolean acceptYours = !isReversed ? resolution == MergeSession.Resolution.AcceptedYours : resolution == MergeSession.Resolution.AcceptedTheirs;
            GitConflict.ConflictSide conflictSide = acceptYours ? GitConflict.ConflictSide.OURS : GitConflict.ConflictSide.THEIRS;
            if (conflictSide == null) {
                MyMergeSession.$$$reportNull$$$0(10);
            }
            return conflictSide;
        }

        @NotNull
        private MultiMap<VirtualFile, GitConflict> groupConflictsByRoot(@NotNull List<? extends VirtualFile> files) {
            if (files == null) {
                MyMergeSession.$$$reportNull$$$0(11);
            }
            MultiMap byRoot = MultiMap.create();
            for (VirtualFile virtualFile : files) {
                GitConflict c = this.myConflicts.get(virtualFile);
                if (c == null) {
                    LOG.error("Conflict was not loaded for the file: " + virtualFile.getPath());
                    continue;
                }
                byRoot.putValue((Object)c.getRoot(), (Object)c);
            }
            MultiMap multiMap = byRoot;
            if (multiMap == null) {
                MyMergeSession.$$$reportNull$$$0(12);
            }
            return multiMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/merge/GitMergeProvider$MyMergeSession";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolution";
                    break;
                }
                case 4: 
                case 6: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergeInfoColumns";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/merge/GitMergeProvider$MyMergeSession";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAcceptedConflictSide";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "groupConflictsByRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canMerge";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "conflictResolvedForFile";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "conflictResolvedForFiles";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptFilesRevisions";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getAcceptedConflictSide";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "groupConflictsByRoot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11 -> new IllegalArgumentException(string);
            };
        }

        private class StatusColumn
        extends ColumnInfo<VirtualFile, String> {
            private final boolean myIsLast;

            StatusColumn(@Nullable boolean isLast, String branchName) {
                super(GitMergeProvider.calcColumnName(isLast, branchName));
                this.myIsLast = isLast;
            }

            public String valueOf(VirtualFile file) {
                GitConflict c = MyMergeSession.this.myConflicts.get(file);
                if (c == null) {
                    return "";
                }
                boolean isReversed = GitMergeProvider.this.myReverseRoots.contains(c.getRoot());
                GitConflict.Status currentStatus = c.getStatus(GitConflict.ConflictSide.OURS, isReversed);
                GitConflict.Status lastStatus = c.getStatus(GitConflict.ConflictSide.THEIRS, isReversed);
                GitConflict.Status status = this.myIsLast ? lastStatus : currentStatus;
                return GitBundle.message((String)(switch (status) {
                    default -> throw new IncompatibleClassChangeError();
                    case GitConflict.Status.ADDED, GitConflict.Status.MODIFIED -> "merge.tool.column.status.modified";
                    case GitConflict.Status.DELETED -> "merge.tool.column.status.deleted";
                }), (Object[])new Object[0]);
            }

            public String getMaxStringValue() {
                return GitBundle.message((String)"merge.tool.column.status.modified", (Object[])new Object[0]);
            }

            public int getAdditionalWidth() {
                return 10;
            }
        }
    }

    private static class Conflict {
        VirtualFile myFile;
        VirtualFile myRoot;
        GitConflict.Status myStatusTheirs;
        GitConflict.Status myStatusYours;

        private Conflict() {
        }
    }
}

