/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookExecutionInfoKt;
import com.intellij.jupyter.core.jupyter.actions.CellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerExecution;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewUpdater;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ;2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001;B\u0011\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020 H\u0016J\u0018\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020 2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010)\u001a\u00020*H\u0016J(\u0010+\u001a\u00020 2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020*H\u0016J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u00020 J\u0006\u00102\u001a\u00020 J\u0006\u00103\u001a\u00020 J\u0006\u00104\u001a\u00020 J\u0018\u00105\u001a\u00020 2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020 2\u0006\u00106\u001a\u000207H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookExecutionInfo;", "Lcom/intellij/jupyter/core/jupyter/actions/CellExecutionListener;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution$Listener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "value", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "currentCell", "getCurrentCell", "()Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "errorCell", "getErrorCell", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "currentStatus", "getCurrentStatus", "()Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "executionQueue", "", "getExecutionQueue", "()Ljava/util/List;", "", "remoteKernelBusyState", "getRemoteKernelBusyState", "()Z", "structureViewUpdater", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewUpdater;", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "subscribeToServerExecution", "", "project", "Lcom/intellij/openapi/project/Project;", "dispose", "executionSubmitted", "cellPointer", "notebook", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "executionStarted", "startTime", "Ljava/time/ZonedDateTime;", "executionStopped", "jupyterStatus", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionStatus;", "endTime", "getQueuedCellsNum", "", "showRemoteKernelBusyState", "stopShowingRemoteKernelBusyState", "reset", "stop", "managedServerStarted", "jupyterServerExecution", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution;", "connectionParameters", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "managedServerStopped", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookExecutionInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookExecutionInfo.kt\ncom/intellij/jupyter/core/editor/NotebookExecutionInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class NotebookExecutionInfo
implements CellExecutionListener,
Disposable,
JupyterServerExecution.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @Nullable
    private NotebookIntervalPointer currentCell;
    @Nullable
    private NotebookIntervalPointer errorCell;
    @Nullable
    private ProgressStatus currentStatus;
    @NotNull
    private final List<NotebookIntervalPointer> executionQueue;
    private boolean remoteKernelBusyState;
    @NotNull
    private final JupyterStructureViewUpdater structureViewUpdater;
    @Nullable
    private MessageBusConnection messageBusConnection;

    private NotebookExecutionInfo(Editor editor) {
        block0: {
            this.editor = editor;
            this.executionQueue = new ArrayList();
            this.structureViewUpdater = new JupyterStructureViewUpdater(this.editor, this);
            JupyterEditorExtensionsKt.getNotebookFile(this.editor).getNotebook().getListeners().getCellExecutionListeners().addListener((EventListener)this);
            Project project = this.editor.getProject();
            if (project == null) break block0;
            Project it = project;
            boolean bl = false;
            this.subscribeToServerExecution(it);
        }
    }

    @Nullable
    public final NotebookIntervalPointer getCurrentCell() {
        return this.currentCell;
    }

    @Nullable
    public final NotebookIntervalPointer getErrorCell() {
        return this.errorCell;
    }

    @Nullable
    public final ProgressStatus getCurrentStatus() {
        return this.currentStatus;
    }

    @NotNull
    public final List<NotebookIntervalPointer> getExecutionQueue() {
        return this.executionQueue;
    }

    public final boolean getRemoteKernelBusyState() {
        return this.remoteKernelBusyState;
    }

    private final void subscribeToServerExecution(Project project) {
        block0: {
            MessageBusConnection messageBusConnection = this.messageBusConnection = project.getMessageBus().connect();
            if (messageBusConnection == null) break block0;
            messageBusConnection.subscribe(JupyterServerExecution.Listener.TOPIC, (Object)this);
        }
    }

    public void dispose() {
        block1: {
            EventDispatcher<CellExecutionListener> eventDispatcher = JupyterEditorExtensionsKt.getNotebookFileOrNull(this.editor);
            if (eventDispatcher != null && (eventDispatcher = eventDispatcher.getNotebookOrNull()) != null && (eventDispatcher = eventDispatcher.getListeners()) != null && (eventDispatcher = eventDispatcher.getCellExecutionListeners()) != null) {
                eventDispatcher.removeListener((EventListener)this);
            }
            MessageBusConnection messageBusConnection = this.messageBusConnection;
            if (messageBusConnection == null) break block1;
            messageBusConnection.disconnect();
        }
    }

    @Override
    public void executionSubmitted(@NotNull NotebookIntervalPointer cellPointer, @NotNull BackedNotebookVirtualFile notebook) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.executionQueue.remove(cellPointer);
        this.executionQueue.add(cellPointer);
    }

    @Override
    public void executionStarted(@NotNull NotebookIntervalPointer cellPointer, @NotNull BackedNotebookVirtualFile notebook, @NotNull ZonedDateTime startTime) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        if (Intrinsics.areEqual((Object)cellPointer, (Object)this.errorCell)) {
            this.errorCell = null;
        }
        this.structureViewUpdater.updateIcons(cellPointer);
        this.currentCell = cellPointer;
        this.currentStatus = ProgressStatus.RUNNING;
    }

    @Override
    public void executionStopped(@NotNull NotebookIntervalPointer cellPointer, @NotNull BackedNotebookVirtualFile notebook, @NotNull JupyterExecutionStatus jupyterStatus, @NotNull ZonedDateTime endTime) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterStatus), (String)"jupyterStatus");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        this.executionQueue.remove(cellPointer);
        switch (WhenMappings.$EnumSwitchMapping$0[jupyterStatus.ordinal()]) {
            case 1: {
                if (!((Collection)this.executionQueue).isEmpty()) {
                    return;
                }
                this.currentStatus = ProgressStatus.STOPPED_OK;
                this.currentCell = cellPointer;
                this.errorCell = null;
                break;
            }
            case 2: {
                this.currentStatus = ProgressStatus.STOPPED_ERROR;
                this.currentCell = cellPointer;
                this.errorCell = cellPointer;
                break;
            }
            case 3: {
                this.executionQueue.clear();
                this.remoteKernelBusyState = false;
                NotebookIntervalPointer notebookIntervalPointer = this.errorCell;
                if (notebookIntervalPointer == null) {
                    notebookIntervalPointer = cellPointer;
                }
                this.currentCell = notebookIntervalPointer;
                this.currentStatus = ProgressStatus.STOPPED_ERROR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.structureViewUpdater.updateIcons(cellPointer);
    }

    public final int getQueuedCellsNum() {
        return this.executionQueue.size();
    }

    public final void showRemoteKernelBusyState() {
        this.remoteKernelBusyState = true;
        this.currentStatus = ProgressStatus.RUNNING;
    }

    public final void stopShowingRemoteKernelBusyState() {
        this.remoteKernelBusyState = false;
        this.currentStatus = null;
    }

    public final void reset() {
        this.currentCell = null;
        this.currentStatus = null;
        this.errorCell = null;
        this.executionQueue.clear();
    }

    public final void stop() {
        this.currentStatus = ProgressStatus.STOPPED_ERROR;
        this.errorCell = this.currentCell;
        this.executionQueue.clear();
    }

    @Override
    public void managedServerStarted(@NotNull JupyterServerExecution jupyterServerExecution, @NotNull JupyterConnectionParameters connectionParameters) {
        Intrinsics.checkNotNullParameter((Object)jupyterServerExecution, (String)"jupyterServerExecution");
        Intrinsics.checkNotNullParameter((Object)connectionParameters, (String)"connectionParameters");
    }

    @Override
    public void managedServerStopped(@NotNull JupyterServerExecution jupyterServerExecution) {
        Intrinsics.checkNotNullParameter((Object)jupyterServerExecution, (String)"jupyterServerExecution");
        this.stop();
    }

    public /* synthetic */ NotebookExecutionInfo(Editor editor, DefaultConstructorMarker $constructor_marker) {
        this(editor);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookExecutionInfo$Companion;", "", "<init>", "()V", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            NotebookExecutionInfo executionInfo = new NotebookExecutionInfo((Editor)editor, null);
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)executionInfo);
            NotebookExecutionInfoKt.access$getNOTEBOOK_EXECUTION_INFO_KEY$p().set((UserDataHolder)editor, (Object)executionInfo);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterExecutionStatus.values().length];
            try {
                nArray[JupyterExecutionStatus.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionStatus.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionStatus.ABORTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

