/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.mpxj.primavera.common.Huffman;

public class Blast {
    private int m_bitbuf;
    private int m_bitcnt;
    private InputStream m_input;
    private OutputStream m_output;
    private int m_left;
    private int m_in;
    private int m_first;
    private int m_next;
    private byte[] m_out = new byte[4096];
    private static final int MAXBITS = 13;
    private static final int MAXWIN = 4096;
    private static final int[] LITLEN = new int[]{11, 124, 8, 7, 28, 7, 188, 13, 76, 4, 10, 8, 12, 10, 12, 10, 8, 23, 8, 9, 7, 6, 7, 8, 7, 6, 55, 8, 23, 24, 12, 11, 7, 9, 11, 12, 6, 7, 22, 5, 7, 24, 6, 11, 9, 6, 7, 22, 7, 11, 38, 7, 9, 8, 25, 11, 8, 11, 9, 12, 8, 12, 5, 38, 5, 38, 5, 11, 7, 5, 6, 21, 6, 10, 53, 8, 7, 24, 10, 27, 44, 253, 253, 253, 252, 252, 252, 13, 12, 45, 12, 45, 12, 61, 12, 45, 44, 173};
    private static final int[] LENLEN = new int[]{2, 35, 36, 53, 38, 23};
    private static final int[] DISTLEN = new int[]{2, 20, 53, 230, 247, 151, 248};
    private static final short[] BASE = new short[]{3, 2, 4, 5, 6, 7, 8, 9, 10, 12, 16, 24, 40, 72, 136, 264};
    private static final int[] EXTRA = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final Huffman LITCODE = new Huffman(14, 256);
    private static final Huffman LENCODE = new Huffman(14, 16);
    private static final Huffman DISTCODE = new Huffman(14, 64);

    public int blast(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.m_input = inputStream;
        this.m_output = outputStream;
        int n = this.bits(8);
        if (n > 1) {
            return -1;
        }
        int n2 = this.bits(8);
        if (n2 < 4 || n2 > 6) {
            return -2;
        }
        while (true) {
            int n3;
            if (this.bits(1) != 0) {
                n3 = this.decode(LENCODE);
                int n4 = BASE[n3] + this.bits(EXTRA[n3]);
                if (n4 == 519) break;
                n3 = n4 == 2 ? 2 : n2;
                int n5 = this.decode(DISTCODE) << n3;
                n5 += this.bits(n3);
                if (this.m_first != 0 && ++n5 > this.m_next) {
                    return -3;
                }
                do {
                    int n6 = this.m_next;
                    int n7 = n6 - n5;
                    int n8 = 4096;
                    if (this.m_next < n5) {
                        n7 += n8;
                        n8 = n5;
                    }
                    if ((n8 -= this.m_next) > n4) {
                        n8 = n4;
                    }
                    n4 -= n8;
                    this.m_next += n8;
                    do {
                        this.m_out[n6++] = this.m_out[n7++];
                    } while (--n8 != 0);
                    if (this.m_next != 4096) continue;
                    this.m_output.write(this.m_out, 0, this.m_next);
                    this.m_next = 0;
                    this.m_first = 0;
                } while (n4 != 0);
                continue;
            }
            n3 = n != 0 ? this.decode(LITCODE) : this.bits(8);
            this.m_out[this.m_next++] = (byte)n3;
            if (this.m_next != 4096) continue;
            this.m_output.write(this.m_out, 0, this.m_next);
            this.m_next = 0;
            this.m_first = 0;
        }
        if (this.m_next != 0) {
            this.m_output.write(this.m_out, 0, this.m_next);
        }
        return 0;
    }

    private int bits(int n) throws IOException {
        int n2 = this.m_bitbuf;
        while (this.m_bitcnt < n) {
            if (this.m_left == 0) {
                this.m_in = this.m_input.read();
                int n3 = this.m_left = this.m_in == -1 ? 0 : 1;
                if (this.m_left == 0) {
                    throw new IOException("out of input");
                }
            }
            n2 |= this.m_in << this.m_bitcnt;
            --this.m_left;
            this.m_bitcnt += 8;
        }
        this.m_bitbuf = n2 >> n;
        this.m_bitcnt -= n;
        return n2 & (1 << n) - 1;
    }

    private int decode(Huffman huffman) throws IOException {
        int n = this.m_bitbuf;
        int n2 = this.m_bitcnt;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        int n7 = 1;
        while (true) {
            if (n2-- != 0) {
                short s;
                if ((n5 |= (n >>= 1) & 1 ^ 1) < n4 + (s = huffman.m_count[n7++])) {
                    this.m_bitbuf = n;
                    this.m_bitcnt = this.m_bitcnt - n6 & 7;
                    return huffman.m_symbol[n3 + (n5 - n4)];
                }
                n3 += s;
                n4 += s;
                n4 <<= 1;
                n5 <<= 1;
                ++n6;
                continue;
            }
            n2 = 14 - n6;
            if (n2 == 0) break;
            if (this.m_left == 0) {
                this.m_in = this.m_input.read();
                int n8 = this.m_left = this.m_in == -1 ? 0 : 1;
                if (this.m_left == 0) {
                    throw new IOException("out of input");
                }
            }
            n = this.m_in;
            --this.m_left;
            if (n2 <= 8) continue;
            n2 = 8;
        }
        return -9;
    }

    private static int construct(Huffman huffman, int[] nArray, int n) {
        int n2;
        int n3;
        short[] sArray = new short[14];
        short[] sArray2 = new short[256];
        int n4 = 0;
        int n5 = 0;
        do {
            n3 = nArray[n5++];
            n2 = (n3 >> 4) + 1;
            n3 &= 0xF;
            do {
                sArray2[n4++] = (short)n3;
            } while (--n2 != 0);
        } while (--n != 0);
        n = n4;
        for (n3 = 0; n3 <= 13; ++n3) {
            huffman.m_count[n3] = 0;
        }
        for (n4 = 0; n4 < n; ++n4) {
            short s = sArray2[n4];
            huffman.m_count[s] = (short)(huffman.m_count[s] + 1);
        }
        if (huffman.m_count[0] == n) {
            return 0;
        }
        n2 = 1;
        for (n3 = 1; n3 <= 13; ++n3) {
            n2 <<= 1;
            if ((n2 -= huffman.m_count[n3]) >= 0) continue;
            return n2;
        }
        sArray[1] = 0;
        for (n3 = 1; n3 < 13; ++n3) {
            sArray[n3 + 1] = (short)(sArray[n3] + huffman.m_count[n3]);
        }
        for (n4 = 0; n4 < n; ++n4) {
            if (sArray2[n4] == 0) continue;
            short s = sArray2[n4];
            short s2 = sArray[s];
            sArray[s] = (short)(s2 + 1);
            huffman.m_symbol[s2] = (short)n4;
        }
        return n2;
    }

    static {
        Blast.construct(LITCODE, LITLEN, LITLEN.length);
        Blast.construct(LENCODE, LENLEN, LENLEN.length);
        Blast.construct(DISTCODE, DISTLEN, DISTLEN.length);
    }
}

